﻿// <copyright file="RadioButtonModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class BooleanControlModel
* Base class for models of controls like RadioButton and Checkbox
*/

define(['common/Enums', 'base/ControlModel'], function (Enums, ControlModel) {

    var BooleanControlModel = ControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'BooleanControlModel';
        },

        getIsChecked: function () {
            return this.get(Enums.ParameterRoles.IS_CHECKED);
        },

        setIsChecked: function (value) {
            this.set(Enums.ParameterRoles.IS_CHECKED, value);
        },

        getTextColor: function () {
            return this.get(Enums.ParameterRoles.TEXT_COLOR);
        },
    });

    return BooleanControlModel;

});