﻿// <copyright file="ControlModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ControlModel
* Base class for models of controls
*/
define(['common/Enums', 'base/Model', 'core/connection/ConnectionHandler', 'core/trigger/TriggerHandler',
    'core/ResourceManager'],
    function (Enums, Model, ConnectionHandler, TriggerHandler, ResourceManager) {

        var MODEL_INIT_EVENT = 'init';
        var MODEL_AFTER_INIT_EVENT = 'after init';

        var ControlModel = Model.extend({

            init: function (type, parentResourceManager) {
                //contains reference to resources dictionary
                //or reference to own dictionary (resources of type + resource of dictionary)
                this.resources = null;
                this._data = null;
                this.events = null; //event[role] = [actionId,....]
                this.actions = []; // { id: {, type: "", constants:{}, parameters: { param: {value: ""}}}}
                this.triggers = [];
                this.permissions = {};
                this._super();

                this.type = type;

                this.serverVariables = {
                    getValues: [],
                    setValues: []
                };

                this._mergeServerVariables(this.serverVariables.getValues, this.type.serverVariables.getValues);
                this._mergeServerVariables(this.serverVariables.setValues, this.type.serverVariables.setValues);

                if (!this.type._connectionsHandler) {
                    this.type._connectionsHandler = new ConnectionHandler();
                }

                mergeEvents.call(this, this.type.events);
                $.extend(true, this.permissions, this.type.permissions);
                //this.permissions = this.permissions.concat(this.type.permissions);
                this.actions = this.actions.concat(this.type.actions);
                this.triggers = this.triggers.concat(this.type.triggers);

                // собственные ресурсы живут в типе, поэтому, сорри, только раз
                if (!this.getType().resourcesProcessed) {
                    this.getType().resourceManager = new ResourceManager();
                    processResources.call(this, this.getType().resources || []);
                    this.getType().resourcesProcessed = true;
                }
                //а вот экзмепляр должен содержать ресурсы типа, и ссылку на родителя
                this.resourceManager = new ResourceManager(parentResourceManager);
                this.resourceManager.setAll(this.getType().resourceManager.getAll());


                processNewParameters.call(this);
            },

            resolveResource: function (resourceName) {

            },

            getType: function () {
                return this.type;
            },

            getConnectionHandler: function () {
                return this.type._connectionsHandler;
            },

            updateTypeConnections: function (ctx) {
                this.getType()._connectionsHandler.updateAll(ctx);
            },

            overrideConnectionsOperation: function (property, operation) {
                this.getType()._connectionsHandler.overrideOperation(property, operation);
            },

            restoreConnectionsOperation: function (property) {
                this.getType()._connectionsHandler.restoreOperation(property);
            },

            updateTypeConnection: function (prop, ctx, sourceOldValue) {
                this.getType()._connectionsHandler.onchange(prop, ctx, sourceOldValue);
            },

            initModel: function (model, context, attachedProperties) {
                this.applyModel(model, context, attachedProperties);
                this.fireOnInit();
                this.fireAllPropertiesChanged();
                this.fireOnAfterInit();
            },
            fireAllPropertiesChanged: function(){
                //TODO: тогда уберем для атачед пропертиес в контейнере
                for (var property in this._data) {
                    this.firePropertyChanged(property);
                }
            },
            applyModel: function (model, context, attachedProperties) {
                //apply model
                if (attachedProperties) {
                    $.extend(true, this._data, attachedProperties);
                }

                if (model && model.parameters) {
                    this._mergeModelParameters(model.parameters);
                }

                if (model && model.events) {
                    mergeEvents.call(this, model.events);
                }

                if (model && model.actions) {
                    this.actions = this.actions.concat(model.actions);
                }

                if (model && model.triggers) {
                    this.triggers = this.triggers.concat(model.triggers);
                }

                if (model && model.permissions) {
                    this.permissions = $.extend(true, this.permissions, model.permissions);
                }

                if (model.serverVariables) {
                    this._mergeServerVariables(this.serverVariables.getValues, model.serverVariables.getValues);
                    this._mergeServerVariables(this.serverVariables.setValues, model.serverVariables.setValues);
                }
            },
            _mergeModelParameters: function (modelParams) {
                var i,
                    propKeys = Object.keys(modelParams);

                for (i = 0; i < propKeys.length; i++) {
                    this._data[propKeys[i]] = {};
                    $.extend(true, this._data[propKeys[i]], modelParams[propKeys[i]]);
                }
            },

            destroy: function () {
                this.actions = null;
                this.triggers = null;
                this.getType()._connectionsHandler.resetLastValues();
            },

            getId: function () {
                return this.get(Enums.ParameterRoles.ID);
            },

            getRole: function () {
                return this.get(Enums.ParameterRoles.ROLE);
            },

            getParameters: function () {
                return this.getType().parameters;
            },

            getTriggers: function () {
                return this.type.triggers;
            },

            getEvents: function () {
                return this.type.events;
            },

            getResourceById: function (id) {
                return this.resources[id];
            },

            getIsVisible: function () {
                return this.get(Enums.ParameterRoles.IS_VISIBLE);
            },

            setIsVisible: function (value) {
                return this.set(Enums.ParameterRoles.IS_VISIBLE, value);
            },

            getOpacity: function () {
                return this.get(Enums.ParameterRoles.OPACITY);
            },

            setOpacity: function (value) {
                return this.set(Enums.ParameterRoles.OPACITY, value);
            },

            getX: function () {
                return this.get(Enums.ParameterRoles.X);
            },

            setX: function (value) {
                return this.set(Enums.ParameterRoles.X, value);
            },

            getXUnits: function () {
                return this.get(Enums.ParameterRoles.X_UNITS);
            },

            getY: function () {
                return this.get(Enums.ParameterRoles.Y);
            },

            setY: function (value) {
                return this.set(Enums.ParameterRoles.Y, value);
            },

            getYUnits: function () {
                return this.get(Enums.ParameterRoles.Y_UNITS);
            },

            getWidthUnits: function () {
                return this.get(Enums.ParameterRoles.WIDTH_UNITS);
            },

            getWidth: function () {
                return this.get(Enums.ParameterRoles.WIDTH);
            },

            setWidth: function (value) {
                return this.set(Enums.ParameterRoles.WIDTH, value);
            },

            getHeightUnits: function () {
                return this.get(Enums.ParameterRoles.HEIGHT_UNITS);
            },

            getHeight: function () {
                return this.get(Enums.ParameterRoles.HEIGHT);
            },

            setHeight: function (value) {
                return this.set(Enums.ParameterRoles.HEIGHT, value);
            },

            getAnchor: function () {
                return this.get(Enums.ParameterRoles.ANCHOR);
            },

            getAngle: function () {
                return this.get(Enums.ParameterRoles.ANGLE);
            },

            setAngle: function (value) {
                return this.set(Enums.ParameterRoles.ANGLE, value);
            },

            setScaleX: function (value) {
                return this.set(Enums.ParameterRoles.SCALE_X, value);
            },

            getIsEnabled: function () {
                return this.get(Enums.ParameterRoles.IS_ENABLED);
            },

            setIsEnabled: function (value) {
                return this.set(Enums.ParameterRoles.IS_ENABLED, value);
            },

            getBackgroundColor: function () {
                return this.get(Enums.ParameterRoles.BACKGROUND_COLOR);
            },

            getBackgroundTile: function () {
                return this.get(Enums.ParameterRoles.BACKGROUND_TILE);
            },

            getShadowColor: function () {
                return this.get(Enums.ParameterRoles.SHADOW_COLOR);
            },

            setShadowColor: function (value) {
                return this.set(Enums.ParameterRoles.SHADOW_COLOR, value);
            },

            getShadowSize: function () {
                return this.get(Enums.ParameterRoles.SHADOW_SIZE);
            },

            getBorderColor: function () {
                return this.get(Enums.ParameterRoles.BORDER_COLOR);
            },

            getBorderStyle: function () {
                return this.get(Enums.ParameterRoles.BORDER_STYLE);
            },

            getBorderThickness: function () {
                return this.get(Enums.ParameterRoles.BORDER_THIKNESS);
            },

            setBorderThickness: function (value) {
                return this.set(Enums.ParameterRoles.BORDER_THIKNESS, value);
            },
            getResource: function () {
                return this.get(Enums.ParameterRoles.RESOURCE);
            },

            setResource: function (value) {
                return this.set(Enums.ParameterRoles.RESOURCE, value);
            },

            _mergeServerVariables: function (existSV, newSV) {
                newSV.forEach(function (sv) {
                    if (_.find(existSV, { 'itemId': sv['itemId'], 'path': sv['path'] }) === undefined) {
                        existSV.push($.extend(true, {}, sv));
                    }
                });
            },

            subscribeOnInit: function (handler, context) {
                this.eventTarget.addListener(MODEL_INIT_EVENT, handler, context);
            },

            unsubscribeOnInit: function (handler) {
                this.eventTarget.removeListener(MODEL_INIT_EVENT, handler);
            },

            fireOnInit: function () {
                this.eventTarget.fire({ type: MODEL_INIT_EVENT, target: this });
            },

            subscribeOnAfterInit: function (handler, context) {
                this.eventTarget.addListener(MODEL_AFTER_INIT_EVENT, handler, context);
            },

            unsubscribeOnAfterInit: function (handler) {
                this.eventTarget.removeListener(MODEL_AFTER_INIT_EVENT, handler);
            },

            fireOnAfterInit: function () {
                this.eventTarget.fire({ type: MODEL_AFTER_INIT_EVENT, target: this });
            },

            //Alex: to let know agility to not make proxy for models
            _noProxy: function () { },
        });

        function processParameter(parameter) {

            if (this._data[parameter.role] === undefined) {
                this._data[parameter.role] = $.extend(true, {}, parameter.defaultValue);
            }
        }

        function processNewParameters() {

            var i,
                parameter,
                parameters = this.getParameters();

            for (i = parameters.length; i--;) {
                parameter = parameters[i];

                processParameter.call(this, parameter);
            }
        }

        function processResources(resources) {
            var shortname;
            for (var i = 0, l = resources.length; i < l; ++i) {
                this.getType().resourceManager.add(resources[i].id, resources[i].url);
                shortname = resources[i].id.slice(resources[i].id.lastIndexOf('.') + 1);
                if (shortname != resources[i].id) {
                    this.getType().resourceManager.add(shortname, resources[i].url);
                }
            }
        }

        function mergeEvents(events) {

            if (!events) {
                return;
            }

            this.events = this.events || {};

            var i;
            for (i = 0; i < events.length; i++) {
                var addingEvent = events[i];
                if (this.events[addingEvent.type]) {
                    this.events[addingEvent.type].actions = this.events[addingEvent.type].actions.concat(addingEvent.actions);
                    this.events[addingEvent.type].isTrigger = this.events[addingEvent.type].isTrigger || this.events[addingEvent.type].isTrigger;
                }
                else {
                    this.events[addingEvent.type] = $.extend(true, {}, addingEvent);
                }
            }
        }

        return ControlModel;
    });
