﻿// <copyright file="ModelProxy.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ObservableObject', 'common/Utilites', 'common/Error'],
    function (Enums, ObservableObject, Utilites, Error) {

        var ModelProxy = ObservableObject.extend({

            init: function (parentModel, namePrefix) {
                this._super();
                this.namePrefix = namePrefix;
                this.parentModel = parentModel;
                this.ClassName = 'Model Proxy';
                this._data = {};
            },
                              

            // Getter
            get: function (arg) {
                return this.parentModel.get(this._getProxiedName(arg));
            },

            // Setter
            set: function (name, value, silent, force) {
                this.parentModel.set(this._getProxiedName(name), value, silent, force);
            },

            getProperty: function (arg) {
                return this.parentModel.getProperty(this._getProxiedName(arg));
            },

            setProperty: function (name, newProperty, silent, force) {
                this.parentModel.setProperty(this._getProxiedName(name), newProperty, silent, force);
            },

            getPropertyType: function (arg) {
                return this.parentModel.getPropertyType(this._getProxiedName(arg));
            },

            _getProperty: function (arg, isCopy) {
                console.warn('should be never used');
            },           

            _getPropertyByPath: function (path) {
                console.warn('should be never used');
            },

            _appendAttributes: function (newProperty, oldProperty) {
                console.warn('should be never used');
            },

            firePropertyChanging: function (name, params) {
                this.parentModel.firePropertyChanging(name, params);
            },

            subscribePropertyChanging: function (handler, context) {
                this.parentModel.subscribePropertyChanging(handler, context);
            },

            subscribePropertyChangingOnce: function (handler, context) {
                this.parentModel.subscribePropertyChangingOnce(handler, context);
            },

            unsubscribePropertyChanging: function (handler) {
                this.parentModel.unsubscribePropertyChanging(handler);

            },
            firePropertyChanged: function (name, oldValue, newValue) {
                this.parentModel.firePropertyChanged(name, oldValue, newValue);
            },

            subscribePropertyChanged: function (handler, context) {
                this.parentModel.subscribePropertyChanged(handler, context);
            },

            subscribePropertyChangedOnce: function (handler, context) {
                this.parentModel.subscribePropertyChangedOnce(handler, context);
            },

            unsubscribePropertyChanged: function (handler) {
                this.parentModel.unsubscribePropertyChanged(handler);
            },

            _getProxiedName: function (name) {
                return this.namePrefix + '.' + name;
            }
        });


        return ModelProxy;
    });
