﻿// <copyright file="RangeControlModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class RangeControlModel base class for models of Slider and ProgressBar
*/

define(['common/Enums', 'base/ControlModel'],
function (Enums, ControlModel) {
    
    var RangeControlModel = ControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'RangeControlModel';

        },

        getValue: function () {
            return this.get(Enums.ParameterRoles.VALUE);
        },

        setValue: function (value) {
            this.set(Enums.ParameterRoles.VALUE, value);
        },

        getMinValue: function () {
            return this.get(Enums.ParameterRoles.MIN_VALUE);
        },

        getMaxValue: function () {
            return this.get(Enums.ParameterRoles.MAX_VALUE);
        },

        getOrientation: function () {
            return this.get(Enums.ParameterRoles.ORIENTATION);
        },

        setOrientation: function (value) {
            return this.set(Enums.ParameterRoles.ORIENTATION, value);
        },

        getTextColor: function () {
            return this.get(Enums.ParameterRoles.TEXT_COLOR);
        }
    });

    return RangeControlModel;
});
