﻿

/*
* @class TextControlController base class for controllers of all controls which can display text
*/

define(['common/Enums', 'common/Appearence', 'base/ControlController'], function (Enums, Appearence, ContainerController) {

        var TextControlController = ContainerController.extend({

            //contains coefficient for calculation actual font size
            //fontSizeRatio == fontSize/width 
            //where width = control.outerWidth 
            //      fontSize = (fontSize from model)		
            init: function () {
                this.fontSizeRatio = null;
                this._super();
                this.modelChanged[Enums.ParameterRoles.TEXT] = this.onTextChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.TEXT_VERTICAL_ALIGN]=this.onTextVerticalAlignChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.TEXT_HORIZONTAL_ALIGN]=this.onTextHorizontalAlignChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.TEXT_COLOR] = this.onTextColorChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FONT_NAME] = this.onFontNameChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FONT_SIZE] = this.onFontSizeChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FONT_MULTILINE] = this.onFontMultilineChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FONT_ITALIC] = this.onFontItalicChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FONT_BOLD] = this.onFontBoldChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.FONT_UNDERLINED] = this.onFontUnderlinedChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.SHADOW_SIZE] = this.onShadowChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.SHADOW_COLOR] = this.onShadowChanged.bind(this);
            },

            onAddedToDOM: function () {
                this._super();
                if (this.mvc.model.get(Enums.ParameterRoles.SKIN)) {
                    this.modelChanged[Enums.ParameterRoles.TEXT] = this.onSvgModelChanged.bind(this, Enums.ParameterRoles.TEXT + ":Content", null);
                    //    this.modelChanged[Enums.ParameterRoles.TEXT_VERTICAL_ALIGN] = this.onTextVerticalAlignChanged.bind(this);
                    //    this.modelChanged[Enums.ParameterRoles.TEXT_HORIZONTAL_ALIGN] = this.onTextHorizontalAlignChanged.bind(this);
                    this.modelChanged[Enums.ParameterRoles.TEXT_COLOR] = this.onSvgModelChanged.bind(this, "Text:fill", null);
                    this.modelChanged[Enums.ParameterRoles.FONT_SIZE] = this.onSvgModelChanged.bind(this, "Text:font-size", null);
                    //    this.modelChanged[Enums.ParameterRoles.FONT_NAME] = this.onFontSizeChanged.bind(this);
                    //    this.modelChanged[Enums.ParameterRoles.FONT_MULTILINE] = this.onFontMultilineChanged.bind(this);
                    this.modelChanged[Enums.ParameterRoles.FONT_ITALIC] = this.onSvgModelChanged.bind(this, "Text:font-style", Appearence.text.getTextItalic);
                    this.modelChanged[Enums.ParameterRoles.FONT_BOLD] = this.onSvgModelChanged.bind(this, "Text:font-weight", Appearence.text.getTextBold);
                    this.modelChanged[Enums.ParameterRoles.FONT_UNDERLINED] = this.onFontUnderlinedChanged.bind(this, "Text:text-decoration", Appearence.text.getTextUnderline);
                    //    this.modelChanged[Enums.ParameterRoles.TEXT_SHADOW_COLOR] = this.onTextShadowColorChanged.bind(this);
                    //    this.modelChanged[Enums.ParameterRoles.TEXT_SHADOW_SIZE] = this.onTextShadowSizeChanged.bind(this);
                }
            },

            textElement: function () {
                return this.mvc.view.$('.text-js');
            },

            displayText: function () {
                this.textElement().text(this.mvc.model.getText());
            },

            applyTextShadow: function () {
                if (Appearence.color.ARGBtoObj(this.mvc.model.getBackgroundColor()).a == 0) {
                    var shadowColor = this.mvc.model.getTextShadowColor();
                    var shadowSize = this.mvc.model.getTextShadowSize();
                    if (Appearence.color.ARGBtoObj(this.mvc.model._data.TextColor.value).a != 0) {
                        Appearence.shadow.applyTextShadow(this.textElement(), { color: shadowColor, size: shadowSize });
                    }
                    else {
                        this.textElement().css('text-shadow', "");
                    }
                }
            },

            onBackgroundColorChanged: function(value) {
                this.onShadowChanged();
                this._super(value);
            },

            onShadowChanged: function() {
                var bgcolor = this.mvc.model.getBackgroundColor();
                if (Appearence.color.parse(bgcolor).brushType == "Solid" && Appearence.color.ARGBtoObj(bgcolor).a == 0) {
                    this.mvc.view.$().css('box-shadow', "");
                    this.applyTextShadow();
                } else {
                    this.textElement().css('text-shadow', "");
                    this.applyShadow();
                }
            },

            applyFontSize: function () {
                if (this.fontSizeRatio && window.initialized && this.mvc.view.$().css('width').indexOf('%') == -1) {
                    var actualSize = this.fontSizeRatio * this.mvc.view.$().width();
                    this.textElement().css('font-size', actualSize + 'px');
                    this.onActualFontSizeChanged(actualSize);
                }
            },

            calculateFontSizeRatio: function () {
                var width = this.mvc.model.get(Enums.ParameterRoles.WIDTH);

                if (width === 0) {
                    this.fontSizeRatio = 0;
                }
                else {
                    this.fontSizeRatio = this.mvc.model.getFontSize() / width;
                }
            },

            skipFireAllProperty: function (property) {

                if (this._super(property)) {
                    return true;
                }

                switch (property) {
                case Enums.ParameterRoles.VALUE_FORMAT:
                case Enums.ParameterRoles.TEXT_SHADOW_COLOR:
                    return true;
                default:
                    return false;
                }
            },
            fireActualWidthChanged: function () {
                if (window.initialized) {
                    this.applyFontSize();
                    this._super();
                }
            },

            onActualFontSizeChanged: function (newValue) {

            },

            modelPropertyChangedInternal: function (event) {
                var value = this.mvc.model.get(event.property);
                if (this.modelChanged[event.property]) {
                    this.modelChanged[event.property](value);
                } else {
                    this._super(event);
                }

            },

            onTextChanged: function (value) {
                this.displayText();
            },

            onTextVerticalAlignChanged: function (value) {
                this.textElement().css('vertical-align', Appearence.text.getTextVAlign(value));
            },

            onTextHorizontalAlignChanged: function (value) {
                this.textElement().css('text-align', Appearence.text.getTextHAlign(value));
            },

            onTextColorChanged: function (value) {
                this.applyTextShadow();
                this.textElement().css('color', Appearence.color.toCssColor(value));
            },

            onFontNameChanged: function (value) {
                this.textElement().css('font-family', value);
            },

            onFontSizeChanged: function (value) {
                this.calculateFontSizeRatio();
                this.applyFontSize();
            },

            onFontMultilineChanged: function (value) {

            },

            onFontItalicChanged: function (value) {
                this.textElement().css('font-style', Appearence.text.getTextItalic(value));
            },

            onFontBoldChanged: function (value) {
                this.textElement().css('font-weight', Appearence.text.getTextBold(value));
            },

            onFontUnderlinedChanged: function (value) {
                this.textElement().css('text-decoration', Appearence.text.getTextUnderline(value));
            },

            onShadowColorChanged: function() {
                this.onShadowChanged();
            },

            onShadowSizeChanged: function() {
                this.onShadowChanged();
            }
	});

	return TextControlController;
});
