﻿define(['common/Enums', 'common/Error', 'common/GeometryNormalizer/Processor/PathCommands/PathSyntaxCommand',
    'common/GeometryNormalizer/Processor/PathSyntaxCommandElement'],
    function (Enums, Error, PathSyntaxCommand, PathSyntaxCommandElement) {
        var HorizontalLineCommand = PathSyntaxCommand.extend({

        parse: function (args) {
            var tempArray = this._splitPath(args),
                i,
                argsCount = this._getArgsCount();
            for (i = 0; i < tempArray.length - (argsCount - 1) ; i += argsCount) {
                this.elements.push(new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X, tempArray[i]));
            }
        },

        getPattern: function () {
            return ' {0} ';
        },

        getCommand: function () {
            return Enums.pathCommand.H;
        }
    });

    return HorizontalLineCommand;
});