﻿// <copyright file="ControlController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'common/Appearence', 'base/BooleanControlController'],
function (Enums, Appearence, BooleanControlController) {

    var CheckBoxController = BooleanControlController.extend({

        init: function () {
            this._super();
            this.ClassName = 'CheckBoxController';
            this.modelChanged[Enums.ParameterRoles.IS_CHECKED] = this.onIsCheckedChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.TEXT_COLOR] = this.onTextColorChanged.bind(this);
        },

        onAddedToDOM: function () {
            this._super();
            if (this.mvc.model.get(Enums.ParameterRoles.SKIN)) {
                this.modelChanged[Enums.ParameterRoles.IS_CHECKED] = this.onSvgIsCheckedChanged.bind(this);
            }
        },

        onIsCheckedChanged: function (value) {
            this.mvc.view.$('g').css('display', Appearence.getDisplay(value));
        },

        onTextColorChanged: function (value) {
            value = Appearence.color.toCssColor(value);
            this.mvc.view.$('g').attr('stroke', value);
        },

        allowAct: function() {
            
            if (!this.mvc.model.getIsEnabled()) {
                return;
            }
            var checked = this.mvc.model.getIsChecked();
            this.mvc.model.setIsChecked(!checked);
        },

        onClick: function (event) {
            this._super(event);
            if (event.handled) {
                return;
            }
            event.handled = true;
           this.askConfirmation();
        },
        renderOverflow: function () {
            this.mvc.view.$().css('overflow', 'visible');
        },
    });

    return CheckBoxController;
});
