﻿// <copyright file="ClockController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


/*
* @class ClockController controller class for Clock control
*/
define(['common/Enums', 'controls/Label/LabelController', 'core/Timer', 'when','common/Appearence'], function (Enums, LabelController, Timer, when, Appereance) {
    //here we will define controller for button

    var ClockController = LabelController.extend({
        _interval: 1000,
        init: function () {
            this._super();
            this.ClassName = 'ClockController';
            this.date = null;
            this.Timer = new Timer(this._interval);
            this.updateTimeWrapper = this.updateTime.bind(this);
            this.Timer.append(this.updateTimeWrapper);
            this.modelChanged[Enums.ParameterRoles.SHADOW_SIZE] = this.onShadowChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHADOW_COLOR] = this.onShadowChanged.bind(this);
        },


        onBackgroundColorChanged: function() {
            this._super();
            this.onShadowChanged();
        },
       

        onAddedToDOM: function () {
            this._super();
            this.refreshTime();
            this.Timer.start();
        },

        updateTime: function () {
            var that = this;
            return when.promise(function (resolve, reject, notify) {
                that.refreshTime();
                resolve();
            });
        },

        modelPropertyChangedInternal: function (event) {
            this._super(event);
            switch (event.property) {
                case Enums.ParameterRoles.TIME_FORMAT:
                case Enums.ParameterRoles.DATE_FORMAT:
                case Enums.ParameterRoles.DATE_TIME_TYPE:
                    this.refreshTime();
                    break;
            }
        },

        refreshTime: function () {
            this.date = new Date();
            var formatString = '';
            switch (this.mvc.model.get(Enums.ParameterRoles.DATE_TIME_TYPE)) {
                case Enums.DateTimeType.Date_Type:
                    formatString = this.mvc.model.get(Enums.ParameterRoles.DATE_FORMAT);
                    break;
                case Enums.DateTimeType.DateTime_Type:
                    formatString = this.mvc.model.get(Enums.ParameterRoles.DATE_FORMAT) + ' ' +
                         this.mvc.model.get(Enums.ParameterRoles.TIME_FORMAT);
                    break;
                case Enums.DateTimeType.Time_Type:
                    formatString = this.mvc.model.get(Enums.ParameterRoles.TIME_FORMAT);
                    break;
                case Enums.DateTimeType.TimeDate_Type:
                    formatString = this.mvc.model.get(Enums.ParameterRoles.TIME_FORMAT) + ' ' +
                         this.mvc.model.get(Enums.ParameterRoles.DATE_FORMAT);
                    break;
            }

            this.textElement().text(String.format(formatString.trim(), this.date));
        }

    });
   
    return ClockController;
});
