﻿// <copyright file="DataTableModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['base/ControlModel', 'common/Enums', 'controls/ParametersFactory', 'common/Error'],
    function (JournalModel, Enums, ParametersFactory, Error) {

    var JournalModel = JournalModel.extend({

        init: function (controlType) {
            this._super(controlType);
            this.ClassName = 'DataTableModel';
            this.typeFields = [];
        },

        initModel: function (model, context, attachedProperties) {
            this._super(model, context, attachedProperties);
        },

        getTableColumns: function () {
            return this.get(Enums.ParameterRoles.TABLE_COLUMNS);
        },

        getOptionsForEM: function(){
            var program = this.get(Enums.ParameterRoles.OBJECT_UID);
            return {
                requestedPublishingInterval: this.get(Enums.ParameterRoles.UPDATE_PERIOD),
                taskId: program.taskNumber,
                itemId: program.itemId,
                path: ''
            };
        },

        getTableColumnsDesc: function () {
            return _.map(this.get(Enums.ParameterRoles.TABLE_COLUMNS), function (column) {
                return {
                    field: column.value[Enums.ParameterRoles.FIELD].value,
                    sortOrder: column.value[Enums.ParameterRoles.SORT].value,
                    name: column.value[Enums.ParameterRoles.DISPLAY_NAME].value,
                    visibility: column.value[Enums.ParameterRoles.VISIBILITY].value,
                    formatString: column.value[Enums.ParameterRoles.VALUE_FORMAT].value,
                    width: column.value[Enums.ParameterRoles.COLUMN_WIDTH].value
                }
            }, this);
        },

        getTableColumns: function () {
            var columns = _.map(this.get(Enums.ParameterRoles.TABLE_COLUMNS), function (column) {
                return this._getTableColumn(column.value);
            }, this);          

            return columns;
        },

        _getTableColumn: function (column)
        {
            return {
                id: 0,
                name: column[Enums.ParameterRoles.FIELD].value,
                type: column[Enums.ParameterRoles.FIELD_TYPE].value,
                typeHash: 0
            }
        },       

        getRowStyle: function () {
            return this.get(Enums.ParameterRoles.ROW_STYLE);
        },

        getSelectedRowStyle: function () {
            return this.get(Enums.ParameterRoles.ROW_STYLE);
        },

        prepareTypeFields: function () {
            //var panelDataSourceProp = this._getProperty(Enums.ParameterRoles.PANEL_DATA_SOURCE);            
            //var type = ParametersFactory.getType(panelDataSourceProp.typeName);            
            //var elementType = ParametersFactory.getType(type.description.arrayItemType);
            //elementType.type = "Локальная.mytestType";
            //this.typeFields = elementType.description;
        },

        getAutoScroll: function () {
            return false;
        },

        getMessages: function () {
            var dataArray = this.get(Enums.ParameterRoles.PANEL_DATA_SOURCE);
            var messageIndex, fieldIndex;
            var messages = [];

            for (messageIndex = 0; messageIndex < dataArray.length; messageIndex++) {
                var fields = Object.keys(dataArray[messageIndex].value);
                var message = {};
                for (fieldIndex = 0; fieldIndex < fields.length; fieldIndex++) {
                    message[fields[fieldIndex]] = dataArray[messageIndex].value[fields[fieldIndex]].value;
                }
                messages.push(message);
            }           

            return messages;
        }
    });

    return JournalModel;
});
