﻿// <copyright file="MessageHolder.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['base/EventTarget', 'common/Enums', 'controls/Journal/modules/MessageHolder', 'common/Utilites'],
    function (EventTarget, Enums, MessageHolder, Utilites) {

        var DataHolder = MessageHolder.extend({

            init: function (journalModel) {
                this.keyFieldName = 'Id';
                this.eventTarget = new EventTarget();
                this.model = journalModel;              
                this.model.subscribePropertyChanged(this.onModelPropertyChanged, this);
                this.messageContainer = {
                    messages: [],
                    messageId: {} //по keyFieldName, ссылка на messages
                }

                this.selectedMessage = null;
                this.columns = this.model.getTableColumns();
            },

            _onMessagesChanged: function (event) {                
                this.messages = this.model.getMessages();
               
                this.fireMessagesUpdated({
                    deletedMessages: [],
                    updatedMessages: [],
                    newMessages: [],
                    refresh: true
                });
            },

            onModelPropertyChanged: function (event) {
                if (event.property === Enums.ParameterRoles.PANEL_DATA_SOURCE) {
                    this._onMessagesChanged(event);
                }
            },

            onAutoScrollChanged: function () {

            },

            hasMessages: function () {
                if (!this.messageContainer.messages) {
                    return false;
                }

                return this.messages.length > 0;
            },

            confirmMessage: function (eventId) {

            },

            selectMessage: function (eventId, messageToSelect) {                
            },

            _getFieldType: function (fieldName) {                
                var field = _.find(this.columns, { name: fieldName });
                if (field === undefined) {
                    return undefined;
                }

                return Utilites.STTypeToJsType(field.type);
            }
        });

        return DataHolder;
    });
