﻿// <copyright file="DateTimePickerController.js" company="ИнСАТ">
// ИнСАТ, 2016
// </copyright>

/*
* @class DateTimePickerController controller class for DateTimePicker control
*/

define(['common/Enums', 'common/Appearence', 'common/Utilites', 'base/TextControlController', 'core/L10n', 'common/Error',
'js!libs/mobiscroll/js/mobiscroll_dom.js!order',
'js!libs/mobiscroll/js/mobiscroll_core.js!order',
'js!libs/mobiscroll/js/mobiscroll_scrollview.js!order',
'js!libs/mobiscroll/js/mobiscroll_frame.js!order',
'js!libs/mobiscroll/js//mobiscroll_scroller.js!order',
'link!libs/mobiscroll/css/mobiscroll_animation.css',
'link!libs/mobiscroll/css/mobiscroll_frame.css',
'link!libs/mobiscroll/css/mobiscroll_icons.css',
'link!libs/mobiscroll/css/mobiscroll_scroller.css'],
 
function (Enums, Appearence, Utilites, TextControlController, L10n, Error) {
    var DateTimePickerController = TextControlController.extend({

        init: function () {
            this._super();
            this.ClassName = 'DateTimePickerController';
            this.pickerInstance = null;
            this.wg = [];
            this.wheelsOrder = [];
        },

        onAddedToDOM: function () {
            this._super();
            this.createPicker();
            this.onReadOnlyChanged();
        },
        formatPickerResult: function (event) {
            var result=this.getDateTimeFromArrayVal(event);
            return String.format('{0:' + this.mvc.model.getDateTimeFormat() + '}', result);
        },
        textElement: function () {
            return this.mvc.view.$();
        },
        updateScrollerValue: function () {
            this.pickerInstance.setArrayVal(this.parseValue(this.mvc.model.getDateTime()), true);
        },
        parseValue: function (value) {
            var time = new Date(value);
            var result = [];
            for (var i = 0; i < this.wheelsOrder.length; i++) {
                switch (this.wheelsOrder[i]) {
                    case 'y':
                        result.push(time.getFullYear());
                        break;
                    case 'M':
                        result.push(time.getMonth() + 1);
                        break;
                    case 'd':
                        result.push(time.getDate());
                        break;
                    case 'H':
                        result.push(time.getHours());
                        break;
                    case 'm':
                        result.push(time.getMinutes());
                        break;
                    case 's':
                        result.push(time.getSeconds());
                        break;
                    case 'f':
                        result.push(time.getMilliseconds());
                        break;
                    default:
                        console.log("неправильный формат даты");
                }
            }
            return result;
        },
        parseString: function (dtText) {
            return this.parseValue(Date.parseString(dtText, this.mvc.model.getDateTimeFormat()));
        },
        getDateTimeFromArrayVal: function(event){
            var result = new Date(0);
            for (var i = 0; i < this.wheelsOrder.length; i++) {
                switch (this.wheelsOrder[i]) {
                    case 'y':
                        result.setFullYear(event[i]);
                        break;
                    case 'M':
                        result.setMonth(event[i] - 1);
                        break;
                    case 'd':
                        result.setDate(event[i]);
                        break;
                    case 'H':
                        result.setHours(event[i]);
                        break;
                    case 'm':
                        result.setMinutes(event[i]);
                        break;
                    case 's':
                        result.setSeconds(event[i]);
                        break;
                    case 'f':
                        result.setMilliseconds(event[i]);
                        break;
                    default:
                        console.log("неправильный формат даты");
                }
            }
            return result;
        },
        applyTextShadow: function () {
            var bg = this.mvc.model.getBackgroundColor();
            if (Appearence.color.parse(bg).brushType == "Solid" && Appearence.color.ARGBtoObj(bg).a == 0) {
                if (Appearence.color.ARGBtoObj(this.mvc.model._data.TextColor.value).a != 0) {
                    Appearence.shadow.applyTextShadow(this.textElement(), {
                        color: this.mvc.model.getShadowColor(),
                        size: this.mvc.model.getShadowSize()
                    });
                }
                else {
                    this.textElement().css('text-shadow', "");
                }
            }
        },
        modelPropertyChangedInternal: function (event) {
            this._super(event);
            if (this.pickerInstance) {
                switch (event.property) {
                    case Enums.ParameterRoles.TIME_FORMAT:
                    case Enums.ParameterRoles.DATE_FORMAT:
                    case Enums.ParameterRoles.DATE_TIME_TYPE:
                        if (this.pickerInstance) {
                            this.pickerInstance.destroy();
                            this.wg = [];
                            this.wheelsOrder = [];
                            this.pickerInstance = null;
                            this.createPicker();
                        }
                    case Enums.ParameterRoles.DATE_TIME:
                        if (this.pickerInstance) {
                            this.updateScrollerValue();
                        }
                        break;
                    case Enums.ParameterRoles.IS_READONLY:
                        this.onReadOnlyChanged();
                        break;
                }
            }
        },
        onReadOnlyChanged: function(){
            if (this.mvc.model.get(Enums.ParameterRoles.IS_READONLY))
                this.pickerInstance.disable();
            else
                this.pickerInstance.enable();
        },
        createPicker: function () {
            this.textElement().text(String.format('{0:' + this.mvc.model.getDateTimeFormat() + '}', new Date(this.mvc.model.getDateTime())));
            var wheels = this.createWheels4Format();
            this.pickerInstance = mobiscroll.scroller(this.textElement(), {
                showLabel: true,
                wheels: wheels,
                setText: L10n.get('dateTime').setText,
                cancelText: L10n.get('dateTime').cancelText,
                display: 'bubble',
                onSet: this.parseWheels.bind(this),
                formatValue: this.formatPickerResult.bind(this),
                parseValue: this.parseString.bind(this)
            });
            this.updateScrollerValue();
        },
        createWheels4Format: function () {
            this.addWheels();
            return [this.wg];
        },
        parseWheels: function (value, inst) {
            this.mvc.model.set(Enums.ParameterRoles.DATE_TIME, this.getDateTimeFromArrayVal(inst.getArrayVal()));
        },
        addWheels: function () {
            var mind = new Date(1970, 0, 1);
            var maxd = new Date(2100, 11, 31, 23, 59, 59);
            var minH = mind.getHours(),
                minM = mind.getMinutes(),
                minS = mind.getSeconds(),
                separator = ' ';
            var offset = 0;
            // Determine the order of hours, minutes, seconds wheels
            var s = L10n.get('dateTime');
            var tord = this.mvc.model.getDateTimeFormat();
            var ord = [];
            var o = {};
            $.each(['H', 'm', 's', 'f', 'y', 'M', 'd'], function (i, v) {
                i = tord.search(new RegExp(v));
                if (i > -1) {
                    ord.push({ o: i, v: v });
                }
            });
            ord.sort(function (a, b) {
                return a.o > b.o ? 1 : -1;
            });
            $.each(ord, function (i, v) {
                o[v.v] = offset + i;
            });
            for (k = 0; k < ord.length; k++) {
                if (k == o.H) {
                    data = [];
                    for (i = minH; i < 24; i++) {
                        data.push({ value: i, display: tord.match(/HH/) && i < 10 ? '0' + i : i });
                    }
                    this._addWheel(data, s.hourText, 'H');
                } else if (k == o.m) {
                    data = [];
                    for (i = minM; i < 60; i++) {
                        data.push({ value: i, display: tord.match(/mm/) && i < 10 ? '0' + i : i });
                    }
                    this._addWheel(data, s.minuteText, 'm');
                } else if (k == o.s) {
                    data = [];
                    for (i = minS; i < 60; i++) {
                        data.push({ value: i, display: tord.match(/ss/) && i < 10 ? '0' + i : i });
                    }
                    this._addWheel(data, s.secText, 's');
                } else if (k == o.f) {
                    data = [];
                    for (i = minS; i < 1000; i++) {
                        data.push({ value: i, display: Utilites._addLeadingZeros(i) });
                    }
                    this._addWheel(data, s.mSecText, 'f');
                } else if (k == o.y) {
                    data = [];
                    start = mind.getFullYear();
                    end = maxd.getFullYear();;
                    for (i = start; i <= end; i++) {
                        data.push({ value: i, display: (tord.match(/yy/i) ? i : (i + '').substr(2, 2)) });
                    }
                    this._addWheel(data, s.yearText, 'y');
                } else if (k == o.M) {
                    data = [];
                    for (i = 1; i < 13; i++) {
                        data.push({ value: i, display: tord.match(/MM/) && i < 10 ? '0' + i : i });
                    }
                    this._addWheel(data, s.monthText, 'M');
                } else if (k == o.d) {
                    data = [];
                    for (i = 1; i < 32; i++) {
                        data.push({ value: i, display: (tord.match(/dd/i) && i < 10 ? '0' + i : i) });
                    }
                    this._addWheel(data, s.dayText, 'd');
                }
            }
        },
        _addWheel: function(values, text, id){
            this.wheelsOrder.push(id);
            this.wg.push({ "data": values, "label": text });
        },
        onDestroy: function() {
            this._super();
            this.pickerInstance = null;
        }
    });

    return DateTimePickerController;
});
