﻿// <copyright file="FrameModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ContainerModel'],
function (Enums, ContainerModel) {

    var FrameModel = ContainerModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'FrameModel';
            this._data[Enums.ParameterRoles.SIZE_TO_CONTENT_ORIGINAL] =
              {
                  "typeName": "HMI.SizeToContentType",
                  "typeHash": 0,
                  "value": null
              };        
        },

        setOriginalSizeContent: function (sizeToContent) {
            this.set(Enums.ParameterRoles.SIZE_TO_CONTENT_ORIGINAL, sizeToContent);
        },

        getOriginalSizeContent: function () {
            return this.get(Enums.ParameterRoles.SIZE_TO_CONTENT_ORIGINAL) ||
                this.get(Enums.ParameterRoles.SIZE_TO_CONTENT);
        },

        setSizeContent: function (sizeToContent) {
            this.set(Enums.ParameterRoles.SIZE_TO_CONTENT, sizeToContent);
        },

        getSizeContent: function () {
            return this.get(Enums.ParameterRoles.SIZE_TO_CONTENT);
        },
    });

    return FrameModel;
});
