﻿define(['common/Enums', 'common/Appearence', 'common/Utilites', 'controls/DateTimePicker/DateTimePickerController', 'core/L10n', 'common/Error'],
 
function (Enums, Appearence, Utilites, DateTimePickerController, L10n, Error) {
    var IntervalPickerController = DateTimePickerController.extend({
        init: function () {
            this._super();
            this.ClassName = 'IntervalPickerController';
        },
        createWheels4Format: function () {
            this.addWheels();
            var order = ['y', 'M', 'd', 'H', 'm', 's', 'f'];
            for (var i = 0; i < order.length; i++) {
                if (this.wheelsOrder.indexOf(order[i]) != -1) {
                    new_data = this.createData4InfiniteWheel();
                    this.wg[this.wheelsOrder.indexOf(order[i])].data = new_data.data;
                    this.wg[this.wheelsOrder.indexOf(order[i])].getIndex = new_data.getIndex;
                    break;
                }
            };            
            return [this.wg];
        },
        createData4InfiniteWheel: function () {
            return {
                data: function (i) {
                    if (i < 0) {
                        i = '';
                    }
                    return {
                        value: i,
                        display: i
                    }
                },
                getIndex: function (value) {
                    if (value < 0) {
                        return 0;
                    }
                    return value;
                }
            }
        },
        formatPickerResult: function (event) {
            var result = this.getDateTimeFromArrayVal(event);
            return Utilites.formatTimeToString(result, this.mvc.model.getTimeFormat());
        },
        getDateTimeFromArrayVal: function(event){
            var result = 0;
            for (var i = 0; i < this.wheelsOrder.length; i++) {
                switch (this.wheelsOrder[i]) {
                    /*case 'y':
                        result+=event[i]*365*24*60*60*1000;
                        break;
                    case 'M':
                        result+=event[i]*30*24*60*60*1000;
                        break;*/
                    case 'd':
                        result+=event[i]*24*60*60*1000;
                        break;
                    case 'H':
                        result+=event[i]*60*60*1000;
                        break;
                    case 'm':
                        result+=event[i]*60*1000;
                        break;
                    case 's':
                        result+=event[i]*1000;
                        break;
                    case 'f':
                        result+=event[i];
                        break;
                    default:
                        console.log("неправильный формат даты");
                }
            }
            return result;
        },
        parseValue: function (value) {
            var ms = value;
            var result = [];
            var d, h, m, s, f;
            f = ms % 1000;
            s = Math.floor(ms / 1000);
            m = Math.floor(s / 60);
            s = s % 60;
            h = Math.floor(m / 60);
            m = m % 60;
            d = Math.floor(h / 24);
            h = h % 24;
            for (var i = 0; i < this.wheelsOrder.length; i++) {
                switch (this.wheelsOrder[i]) {
                    case 'd':
                        result.push(d);
                        break;
                    case 'H':
                        result.push(h);
                        break;
                    case 'm':
                        result.push(m);
                        break;
                    case 's':
                        result.push(s);
                        break;
                    case 'f':
                        result.push(f);
                        break;
                    default:
                        console.log("неправильный формат даты");
                }
            }
            return result;
        },
        updateScrollerValue: function () {
            var val = this.parseValue(this.mvc.model.getDateTime());
            this.pickerInstance.setArrayVal(val, true);
        }
    });

    return IntervalPickerController;
});
