﻿// <copyright file="JournalModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['base/ControlModel', 'core/L10n', 'common/Enums'], function (ControlModel, L10n, Enums) {

    var JournalModel = ControlModel.extend({
        l10Prefix: "journalGrid.",
        ackField: 'Ack',
        iconField: 'Icon',
        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);
            this.ClassName = 'JournalModel';
            this.ackBtnText = L10n.get(this.l10Prefix + 'ackBtnText');
            this._data[Enums.ParameterRoles.PAGE_INTERVAL] = {
                typeName: "TIME",
                typeHash: 0,
                value: 0
            };

            this._data[Enums.ParameterRoles.RIGHT_BORDER] = {
                typeName: "DATE_AND_TIME",
                typeHash: 0,
                value: 0
            };

            this._data[Enums.ParameterRoles.LEFT_BORDER] = {
                typeName: "DATE_AND_TIME",
                typeHash: 0,
                value: 0
            };

            this._data[Enums.ParameterRoles.PAGE_RIGHT_BORDER] = {
                typeName: "DATE_AND_TIME",
                typeHash: 0,
                value: 0
            };

            this._data[Enums.ParameterRoles.PAGE_LEFT_BORDER] = {
                typeName: "DATE_AND_TIME",
                typeHash: 0,
                value: 0
            };

            this._data[Enums.ParameterRoles.PAGE_MESSAGE_COUNT] = {
                typeName: "INT",
                typeHash: 0,
                value: 0
            };
                        
            this._data[Enums.ParameterRoles.PAGE_MESSAGE_COUNT] = {
                typeName: "INT",
                typeHash: 0,
                value: 0
            };

            this._data[Enums.ParameterRoles.AUTOSCROLL_STOP_REASON] = {
                typeName: "STRING",
                typeHash: 0,
                value: Enums.autoscrollStopReason.none
            };

            this.pageInterval = 0;
            this.convertersCache = {};
        },

        getRightBorder: function () {
            return this.get(Enums.ParameterRoles.RIGHT_BORDER);
        },

        setRightBorder: function (timestamp, slient) {
            this.set(Enums.ParameterRoles.RIGHT_BORDER, timestamp, slient);    
            this.set(Enums.ParameterRoles.TILL, timestamp);
        },

        getLeftBorder: function () {
            return this.get(Enums.ParameterRoles.LEFT_BORDER);
        },

        setLeftBorder: function (timestamp, slient) {
            this.set(Enums.ParameterRoles.LEFT_BORDER, timestamp, slient);
        },

        getPageInterval: function(){
            return this.get(Enums.ParameterRoles.PAGE_INTERVAL);
        },

        setPageInterval: function (interval, slient) {
            this.set(Enums.ParameterRoles.PAGE_INTERVAL, interval, slient);
        },

        getPageMessageCount: function () {
            return this.get(Enums.ParameterRoles.PAGE_MESSAGE_COUNT);
        },

        setPageMessageCount: function (count, slient) {
            this.set(Enums.ParameterRoles.PAGE_MESSAGE_COUNT, count, slient);
        },

        getPageMessageLimit: function () {
            return this.get(Enums.ParameterRoles.LIMIT);
        },

        getShowFilter: function () {
            return this.get(Enums.ParameterRoles.SHOW_FILTER);
        },

        getInterval: function () {
            return this.get(Enums.ParameterRoles.INTERVAL);
        },

        getShowLegend: function () {
            return this.get(Enums.ParameterRoles.SHOW_LEGEND);
        },

        getShowGrid: function () {
            return this.get(Enums.ParameterRoles.SHOW_GRID);
        },

        getFullScreen: function () {
            return this.get(Enums.ParameterRoles.FULL_SCREEN);
        },

        getAutoScroll: function () {
            return this.get(Enums.ParameterRoles.AUTOSCROLL);
        },

        getFilters: function () {
            return this.get(Enums.ParameterRoles.FILTERS);
        },

        getLegendColumns: function () {
            return this.get(Enums.ParameterRoles.LEGEND_COLUMNS);
        },

        getTableColumns: function () {
            return this.get(Enums.ParameterRoles.TABLE_COLUMNS);
        },

        getOptionsForEM: function(){
            var program = this.get(Enums.ParameterRoles.OBJECT_UID);
            return {
                requestedPublishingInterval: this.get(Enums.ParameterRoles.UPDATE_PERIOD),
                taskId: program.taskNumber,
                itemId: program.itemId,
                path: '',
                maxSize:  this.get(Enums.ParameterRoles.LIMIT)
            };
        },

        getTableColumnsDesc: function () {
            var tableColumns =  _.map(this.get(Enums.ParameterRoles.TABLE_COLUMNS), function (column) {
                return {
                    field: column.value[Enums.ParameterRoles.FIELD].value,
                    sortOrder: column.value[Enums.ParameterRoles.SORT].value,
                    name: column.value[Enums.ParameterRoles.DISPLAY_NAME].value,
                    visibility: column.value[Enums.ParameterRoles.VISIBILITY].value,
                    formatString: column.value[Enums.ParameterRoles.VALUE_FORMAT].value,
                    width: column.value[Enums.ParameterRoles.COLUMN_WIDTH].value,
                    align: column.value['HorizontalAlign'].value
                }
            }, this);
            
            var ackColumn = _.find(tableColumns, function (tableColumn) {
                return tableColumn.field === this.ackField;
            }, this);
            
            if (ackColumn !== undefined) {
                $.extend(ackColumn, {                 
                    sortOrder: Enums.SortType.No,                        
                    formatString: null,                    
                    sortDisabled: true,
                    template: '<div class="journal-grid-confirm-div"><input type="button" class="journal-grid-confirm" value="' + this.ackBtnText + '"></div>'
                });
            }

            var iconColumn = _.find(tableColumns, function (tableColumn) {
                return tableColumn.field === this.iconField;
            }, this);

            if (iconColumn !== undefined) {
                $.extend(iconColumn, {
                    field: 'EventType', //Icon->EventType
                    sortOrder: Enums.SortType.No,
                    formatString: null,                  
                    sortDisabled: true,
                    template: '<div class="journal-grid-icon-div"></div>'
                });
            }

            tableColumns.unshift({
                field: 'EventId',
                sortOrder: Enums.SortType.No,
                name: '', //EventId
                visibility: false,
                formatString: null,
                width: '0px',
            });

            tableColumns.unshift({
                field: 'Marker',
                sortOrder: Enums.SortType.No,
                name: '', //Marker
                visibility: true,
                formatString: null,
                width: '20px',
                sortDisabled: true,
                template: '<div class="journal-grid-selector" style="display:none"><svg height="100%" width="100%" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M8 4 V28 L26 16 z"/></svg></div>'
            });           

            return tableColumns;
        },

        getAllColumnsForEM: function () {
            var columns = _.map(this.get(Enums.ParameterRoles.TABLE_COLUMNS), function (column) {
                return this._getColumnForEM(column.value);
            }, this);

            _.forEach(this.getLegendColumns(), function (column) {
                var existingColumn = _.find(columns, { name: column.value[Enums.ParameterRoles.FIELD].value });
                if (existingColumn === undefined) {
                    columns.push(this._getColumnForEM(column.value));
                }
            }, this);

            _.forEach(this.getRowStyle(), function (column) {
                var existingColumn = _.find(columns, { name: column.metadata.Field });
                if (existingColumn === undefined && column.metadata.Field) {
                    columns.push({
                                    id: 0,
                                    name: column.metadata.Field,
                                    type: column.typeName,
                                    typeHash: 0
                    });
                }
            }, this);

            var iconColumn = _.find(columns, { name: 'Icon' });

            if (iconColumn) {
                //в таблице - иконка, но с сервера запрашиваем EventType
                iconColumn.name = 'EventType';
                iconColumn.type = "STRING";
                iconColumn.typeHash = 0;
            }
            //EventType

            var eventIdColumn = _.find(columns, { name: 'EventId' });
            //обязательно нужна для сортировки по умолчанию
            if (!eventIdColumn) {
                columns.push({
                    id: 0,
                    name: "EventId",
                    type: "STRING",
                    typeHash: 0
                });
            }          

            var activeTimeColumn = _.find(columns, { name: 'ActiveTime' });
            //обязательно нужна для сортировки по умолчанию
            if (!activeTimeColumn) {
                columns.push({
                    id: 0,
                    name: "ActiveTime",
                    type: "DATE_AND_TIME",
                    typeHash: 2
                });
            }
            
            //не запрашиваем кнопку квитирования
            _.remove(columns, function (column) {
                return column.name === this.ackField;
            }, this);           

            return columns;
        },

        _getColumnForEM: function(column)
        {
            return {
                id: 0,
                name: column[Enums.ParameterRoles.FIELD].value,
                type: column[Enums.ParameterRoles.FIELD_TYPE].value,
                typeHash: 0
            }
        },

        getFiltersForEM: function () {
            var filters = [];
            _.forEach(this.getFilters(), function (filter) {
                if (filter.value[Enums.ParameterRoles.ENABLED].value === true) {
                    filters.push(filter.value[Enums.ParameterRoles.CONDITION].value);
                }
            }, this);

            return filters;
        },

        getRowStyle: function () {
            return this.get(Enums.ParameterRoles.ROW_STYLE);
        },

        getHeaderRowStyle: function () {
            return this.get(Enums.ParameterRoles.HEADER_ROW_STYLE);
        },

        isToolBarEnabled: function () {
            return this.get(Enums.ParameterRoles.SHOW_TOOLBAR);
        },

        startAutoscroll: function () {
            this.set(Enums.ParameterRoles.AUTOSCROLL_STOP_REASON, Enums.autoscrollStopReason.none);
            this.set(Enums.ParameterRoles.AUTOSCROLL, true);
        },

        stopAutoscroll: function (reason) {
            this.set(Enums.ParameterRoles.AUTOSCROLL_STOP_REASON, reason);
            this.set(Enums.ParameterRoles.AUTOSCROLL, false);
        },

        getAutoscrollStopReason: function () {
            return this.get(Enums.ParameterRoles.AUTOSCROLL_STOP_REASON);
        }
    });

    return JournalModel;
});
