﻿// <copyright file="DetailModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ModelProxy', 'common/Utilites', 'common/Error'],
    function (Enums, ModelProxy, Utilites, Error) {

        var DetailModel = ModelProxy.extend({

            init: function (parentModel, id) {
                this._super(parentModel, String.format('{0}[{1}]', Enums.ParameterRoles.LEGEND_COLUMNS, id));                
                this.ClassName = 'Filter Model';              
            },

            getDisplayName: function () {
                return this.get(Enums.ParameterRoles.DISPLAY_NAME);
            },
            getVisibility: function () {
                return this.get(Enums.ParameterRoles.VISIBILITY);
            },
            getField: function () {
                return this.get(Enums.ParameterRoles.FIELD);
            },
            getValueFormat: function () {
                return this.get(Enums.ParameterRoles.VALUE_FORMAT);
            }
        });


        return DetailModel;
    });
