﻿// <copyright file="Filter.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['base/EventTarget', 'common/Enums', 'common/Appearence', 'helpers/PathBuilder',
    'controls/Journal/modules/filter/FilterModel'], function (EventTarget, Enums, Appearence,
        PathBuilder, FilterModel) {
    var placeholder = 'ul';

    var FILTER_STATE_CHANGED = 'FilterStateChanged',
        CONDITION_STATE_CHANGED = 'ConditionStateChanged',
        enabledKey = 'Enabled',
        canDisableKey = 'CanDisable'

    filterProto = $$({
        view: {
            format: '<li><input type="checkbox" data-bind="id=id, Enabled"><span data-bind="DisplayName"></span></li>'
        },
        _controller: {
            'click &': function () {
                this.trigger(CONDITION_STATE_CHANGED, {
                    enabled: this.view.$('input').prop('checked') //hello FF
                });

            }
        },
        setValue: function (propertyName, value) {         
            var obj = {};
            obj[propertyName] = value;
            this._model.set(obj);

            if (propertyName === Enums.ParameterRoles.CAN_DISABLE) {
                this.updateReadOnly();
            }
        },

        updateReadOnly: function () {
            var value = this._model.get(canDisableKey);
            Appearence.applyDisabled(this.view.$('input'), !value);
        }
    });

    var Filter = Class.extend({
        init: function (id, journalModel) {
            this.id = id;
            this.model = new FilterModel(journalModel, id);
            this.model.subscribePropertyChanged(this.onModelPropertyChanged, this);
            this._onFilterClickWrapper = this._onFilterClick.bind(this);
            this.filter = null;
            this._createFilter();
        },

        _createFilter: function () {           
            this.filter = $$(filterProto,
                {
                    _model: {
                        id: this.id,
                        DisplayName: this.model.getDisplayName(),
                        Enabled: this.model.getEnabled(),
                        CanDisable: this.model.getCanDisable(),
                    }                 
                });

            this.filter.bind(CONDITION_STATE_CHANGED, this._onFilterClickWrapper);
            this.filter.updateReadOnly();
        },

        stylize: function () {

        },

        afterRender: function (options) {

        },

        render: function (container) {
            container.children(placeholder).append(this.filter.view.$());
        },

        _onFilterClick: function (event, args) {
            this.model.set(Enums.ParameterRoles.ENABLED, args.enabled);
        },

        onModelPropertyChanged: function (event) {     
            var pathArray = new PathBuilder(event.property).getArray();
            if (pathArray[0] === Enums.ParameterRoles.FILTERS &&
                pathArray[1] === this.id.toString()) {
                this.filter.setValue(pathArray[2], this.model.get(pathArray[2]));               
            }
        }
    });

    return Filter;
});