﻿// <copyright file="FilterModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ModelProxy', 'common/Utilites', 'common/Error'],
    function (Enums, ModelProxy, Utilites, Error) {

        var FilterModel = ModelProxy.extend({

            init: function (parentModel, id) {
                this._super(parentModel, String.format('{0}[{1}]', Enums.ParameterRoles.FILTERS, id));                
                this.ClassName = 'Filter Model';              
            },

            getDisplayName: function () {
                return this.get(Enums.ParameterRoles.DISPLAY_NAME);
            },

            getEnabled: function () {
                return this.get(Enums.ParameterRoles.ENABLED);
            },

            getCanDisable: function () {
                return this.get(Enums.ParameterRoles.CAN_DISABLE);
            },

            getCondition: function () {
                return this.get(Enums.ParameterRoles.CONDITION);
            },

        });


        return FilterModel;
    });
