﻿// <copyright file="Grid.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'controls/Journal/modules/GridHelper',
    'controls/Journal/modules/grid/body/Body',
    'controls/Journal/modules/grid/header/Header',
    'controls/Journal/modules/grid/header/ThTemplate',
    'controls/Journal/modules/grid/Scroll',
    'controls/Journal/modules/grid/Table',
    'core/L10n', 'common/Appearence'
], function (Enums, helper, Body, Header, ThTemplate, Scroll, Table, L10n, Appearence) {
 
    var l10Prefix = "journalGrid.";
    var ackPromptTitle, ackPromptMessage;

    var bottomBarHeight = 20;
    var toolbarHeight = 50; 
    var markerWidth = 20;
    var rowPadding = 1;   
    //на 1 меньше, чем действительно в css, т.к верхняя строка
    //по законам хогвартса на 1 больше
    var Grid = Class.extend({
        iconPrefix : '_event_',
        init: function (messageHolder, journalModel) {
            ackPromptTitle = L10n.get(l10Prefix + 'ackPromptTitle');
            ackPromptMessage = L10n.get(l10Prefix + 'ackPromptMessage');           
            this.keyField = 'EventId';
            this.ackedKeyField = 'Acked';
            this.ackedBtnKeyField = 'AckedBtn';
            this.messageHolder = messageHolder;
            this.model = journalModel;
            this.isEnabled = true;
            this.activeTimeField = 'ActiveTime';
            this.eventTypeKeyField = 'EventType';
            this.commentKeyField = 'Comment';

            var that = this;
            this.ths = [];

            this.table = new Table(this);
            this.thead = new Header(journalModel, messageHolder);          
            this.tbody = new Body(this, messageHolder, journalModel);

            this.rowTemplate = $$({
                _model: {},
                view: {
                    format: '<tr>'
                },
                _controller: {
                    'click .journal-grid-confirm': function () {
                        // пока без комментария, потом он будет в строке статуса
                        if (!that.isEnabled) {
                            return;
                        }
                        that.confirmMessage(this._model.get(that.keyField), this._model.get(that.commentKeyField));
                    },
                    'click &': function () {
                        if (!that.isEnabled) {
                            return;
                        }

                        if (this.parent()
                            .selectedRow !== null) {
                            this.parent()
                                .selectedRow.setNormal();
                        }
                        this.parent()
                                .selectedRowEventId = this._model.get(that.keyField);
                        this.parent()
                            .selectedRow = this;
                        this.setSelected();
                        that.getSelectedMessage(this._model._data);
                    }
                },
                setSelected: function () {
                    that._updateCustomRowSelectedColumnsStyle(this.view.$('td'));
                },
                setNormal: function () {
                    var cssObj = helper.updateStyles(that.model.getRowStyle(), this._model.get(),
                        that.model.convertersCache[Enums.ParameterRoles.ROW_STYLE]);
                    this.applyRowStyle(cssObj);
                    that._updateCustomRowColumnsStyle(this.view.$('td'), cssObj);
                },
                applyRowStyle: function (cssObj) {
                    var backgroundColor = cssObj['BackgroundColor'];
                    delete cssObj['BackgroundColor'];

                    this.view.$().css(cssObj);
                    Appearence.background.apply(this.view.$(), backgroundColor);

                    if (cssObj) {
                        this.view.$().children('td')
                            .children('div')
                            .height(cssObj.height);
                    }                    
                },
                applyRowColumnStyles: function (columnsStyles) {
                    var tds = this.view.$('td');                   
                    that._updateColumnStyles(this, columnsStyles);
                },

                refresh: function () {
                    var acked = this._model.get(that.ackedBtnKeyField);
                    this.view.$('.journal-grid-confirm-div').css("display", !acked ? '' : 'none');
                    var icon = this._model.get(that.eventTypeKeyField);
                    if (icon) {                       
                        resourceUrl = that.model.resourceManager.resolve(that.iconPrefix + icon);
                        Appearence.background.applyBgImage(this.view.$('.journal-grid-icon-div'), resourceUrl);
                    } else {
                        Appearence.background.applyBgImage(this.view.$('.journal-grid-icon-div'), null);
                    }
                },

                hide: function () {
                    this.view.$()
                        .hide();
                    this.view.$()
                        .height(0);
                }
            });

            this.scroll = new Scroll(this, messageHolder, journalModel);
            var that = this;

            this.messageHolder.subscribeMessagesUpdated(function (changes) {
                this.refresh(changes.newMessages && changes.newMessages.length > 0);
            }, this);

        },

        _onSortOrderChanged: function () {
            if (this.model.getAutoScroll()) {
                //Переключение сортировки - автопрокрутка отключается.                 
                if ((this.currentSortField !== this.activeTimeField) || (this.currentSortOrder !== Enums.SortType.Desc)) {
                    this.model.stopAutoscroll(Enums.autoscrollStopReason.sortChange);
                }
            } else {
                //При включении сортировки по времени автопрокрутка включается обратно.
                if ((this.currentSortField === this.activeTimeField) && (this.currentSortOrder === Enums.SortType.Desc) &&
                    this.model.getAutoscrollStopReason() === Enums.autoscrollStopReason.sortChange) {
                    this.model.startAutoscroll();
                }
            }
        },

        _onScrollpositionChanged: function (isByUser) {
             this.updateViewPort();           

            //Сдвиг скроллбара вниз - автопрокрутка отключается
            if (isByUser && this.model.getAutoScroll() && !this.scroll.isAtTop()) {
                this.model.stopAutoscroll(Enums.autoscrollStopReason.scrollChange);
            }/* else if (this.model.getAutoscrollStopReason() === Enums.autoscrollStopReason.scrollChange &&
                this.scroll.isAtTop()) {
                this.model.startAutoscroll();
            }*/
         },

        _onAutoScrollChanged: function (event) {
            if (this.model.getAutoScroll()) {
                this.currentSortField = this.activeTimeField;
                this.currentSortOrder = Enums.SortType.Desc;
                this.thead.setSortColumn(this.activeTimeField, this.currentSortOrder);
                this.selectFirstMessage();
            }
        },

        _updateCustomRowColumnsStyle: function (tds, cssObj) {            
            tds.children('.journal-grid-selector').hide();
            tds.children('.journal-grid-confirm-div').css(cssObj).css({ height: 'auto' });
        },

        _updateCustomRowSelectedColumnsStyle: function (tds) {
            tds.children('.journal-grid-selector').show();
        },

        //обновляет ширину по рассчитаным стилям для колонок
        _updateColumnStyles: function (context, columnsStyles) {
            var tds = context.view.$('td');           
            for (var i = 0; i < tds.length; i++) {               
                if (columnsStyles[i].type == 'px') {
                    $(tds[i])
                        .children()
                        .css('width', columnsStyles[i].width);
                }
                $(tds[i])
                    .css({
                        width: columnsStyles[i].width,
                        display: columnsStyles[i].display
                    });

                $(tds[i])
                       .children()
                       .css('text-align', Appearence.text.getTextHAlign(columnsStyles[i].align));
            }
        },               

        initialize: function () {
            this.isEnabled = this.model.get(Enums.ParameterRoles.IS_ENABLED);
            this.model.subscribePropertyChanged(this.onModelPropertyChanged, this);

            this.currentSortField = this.activeTimeField;
            this.currentSortOrder = Enums.SortType.Desc;
            this.columns = this.model.getTableColumnsDesc();

            if (this.columns && this.columns.length > 0) {
                for (var i = 0; i < this.columns.length; i++)
                    if (this.columns[i].sortOrder != Enums.SortType.No) {
                        this.currentSortField = this.columns[i].field;
                        this.currentSortOrder = this.columns[i].sortOrder;
                        break;
                    }
            }

            this.table.append(this.scroll, '.journal-grid');
            this.table.scroll = this.scroll;
            this.table.thead = this.thead;
            this.tbody.table = this.table;
            this.table.tbody = this.tbody;
            this.table.append(this.thead, 'table');
            this.table.append(this.tbody, 'table');
        },

        onModelPropertyChanged: function (event) {
            switch (event.property) {
                case Enums.ParameterRoles.IS_ENABLED:
                    this._onIsEnabledChanged(event);
                    break;
                case Enums.ParameterRoles.AUTOSCROLL:
                    this._onAutoScrollChanged(event);
                    break;
                default:
                    if(event.property.indexOf(Enums.ParameterRoles.HEADER_ROW_STYLE) === 0){             
                        this._applyHeaderStyle();
                        break;
                    }
                    if (event.property.indexOf(Enums.ParameterRoles.ROW_STYLE) === 0) {
                        this.refresh();
                        break;
                    }
            }
        },    

        _onIsEnabledChanged: function (event) {
            this.isEnabled = this.model.get(Enums.ParameterRoles.IS_ENABLED);
            this.tbody.view.$('input').prop("disabled", !this.isEnabled);
        },

        render: function (container) {
            this.view = container[0];
            //формируем заголовок           
            _.forEach(this.columns, function (column) {
                var th = new ThTemplate(this, column);

                this.thead.append(th, 'tr');
                this.thead.headers.push(th);

                if (column.field === this.currentSortField) {
                    th.setAsSortColumn(this.currentSortOrder);
                }

                if (column.template) {
                    this.rowTemplate.view.format += '<td>' + column.template + '</td>';
                } else {
                    this.rowTemplate.view.format += '<td><div data-bind="' + column.field + ',title=' + column.field + '"></div></td>';
                }
            }, this);
            this.rowTemplate.view.format += '</tr>';

            container.find('[placeholder="grid"]').append(this.table.view.$());
        },
              
        stylize: function (styles) {
            //получаем стили           
        },

        _applyHeaderStyle: function () {
            var headerStyleCssObj = helper.updateStyles(this.model.getHeaderRowStyle());
            this.thead.applyHeadersRowStyle(headerStyleCssObj);
        },

        afterRender: function (height) {
            //выставляем ширину заголовков
            var columnsStyles = helper.getColumnsStyles(this.columns, this.table.getInnerWidth());
            this.thead.applyHeadersStyles(columnsStyles);
            this._applyHeaderStyle();

            this.table.init(height);
            this.tbody.view.$()
                .children()
                .css('display', 'none');
            this._onIsEnabledChanged();
        },                 

        updateScrollStatus: function () {
            var messages = this.messageHolder.getMessages();
            //берем меньше, что бы последнее сообщение не обрезалось
            if (this.tbody.rows.length < messages.length) {
                //в слайдере берем сообщения по его позиции + величина вьюпорта
                //поэтому последний вьюпорт брать нет смысла       
                this.scroll.setMax(messages.length - this.tbody.rows.length);
                if ((this.scroll.visible === false) || (this.model.getAutoScroll())) {
                    //был спрятан, ставим на верхнюю позицию
                    this.scroll.scrollToStart();
                }

                this.scroll.show(true);
            } else {
                this.scroll.hide(false);
            }
        },

        updateViewPort: function (selectFirst) {
            var messages = this.messageHolder.sort(this.currentSortField, this.currentSortOrder);
            //console.log(this.scroll.sliderPosition);
            this.bindMessages(this.messageHolder.getMessages(this.scroll.sliderPosition, this.scroll.sliderPosition + this.tbody.rows.length));          
        },        

        bindMessages: function (messages) {
            if (this.tbody.rows.length === 0) {
                return;
            }

            var columnsStyles = helper.getColumnsStyles(this.columns, this.table.getInnerWidth(), messages);
            var rowStyles = this.model.getRowStyle();
            this.table.applyColumnsStyles(columnsStyles);
            this.tbody.cancelSelectedRowStyle();
            var i = 0;
            for (i = 0; i < this.tbody.rows.length && i < messages.length; i++) {
                this.tbody.rows[i]._model.set(helper.formatMessage(messages[i], this.columns), {
                    silent: true
                });

                var cssObj = helper.updateStyles(rowStyles, messages[i],
                    this.model.convertersCache[Enums.ParameterRoles.ROW_STYLE]);

                this.tbody.rows[i].applyRowStyle(cssObj);
                this._updateCustomRowColumnsStyle(this.tbody.rows[i].view.$('td'), cssObj);

                var ackObj = {};
                ackObj[this.ackedBtnKeyField] = messages[i][this.ackedKeyField];
                this.tbody.rows[i]._model.set(ackObj, {
                    silent: true
                });

                this.tbody.rows[i].view.sync();
                this.tbody.rows[i].view.$()
                    .css('display', '');
                this.tbody.rows[i].refresh();                
            }
            //this.tbody.applyRowStylesBlock();
            //прячем оставшиеся
            for (i; i < this.tbody.rows.length; i++) {
                this.tbody.rows[i].hide();
            }

            this.tbody.updateSelectedRowStyle();
        },

        getSelectedMessage: function (message) {
            this.messageHolder.selectMessage(message[this.keyField], message);
        },

        refresh: function (selectFirst) {
            this.updateViewPort(selectFirst);
            this.updateScrollStatus();

            //Если включена автопрокрутка - выделять всегда послденее сообщение из списка. 
            if (this.model.getAutoScroll() && selectFirst) {               
                this.selectFirstMessage();
            }
        },       

        setHeight: function (height) {
            this.table.setHeight(height);
        },      

        show: function () {
            this.table.show();
            this.table.applyHeight();
        },

        hide: function () {
            this.table.hide();
        },

        selectFirstMessage: function () {
            this.scroll.changePosition(this.tbody.rows.length);
            var messages = this.messageHolder.getMessages();
            this.tbody.cancelSelection();
            if (messages.length > 0) {              
                //this.scroll.scrollToStart();
                this.selectRow(messages[0][this.keyField]);
            }
        },

        selectPreviousMessage: function () {
            this.selectMessageWithStep(-1);
        },

        selectNextMessage: function () {
            this.selectMessageWithStep(1);
        },

        selectMessageWithStep: function (step) {
            var isNext = step > 0;
            var messages = this.messageHolder.getMessages();
            var obj = {};
            obj[this.keyField] = this.tbody.selectedRowEventId;
            var selectedMessageIndex = _.findIndex(messages, obj);
            if ((selectedMessageIndex == -1) || (isNext && selectedMessageIndex === messages.length - 1) || (!isNext && selectedMessageIndex === 0)) {
                return; //если последнее/первое сообщение
            }
            if (this.tbody.selectedRowEventId !== -1) {
                for (var i = 0; i < this.tbody.rows.length; i++) {
                    if (this.tbody.rows[i]._model.get(this.keyField) === this.tbody.selectedRowEventId) {
                        if ((isNext && i >= this.tbody.rows.length - 1) || (!isNext && i === 0)) {
                            break; //если первое/последнее на этом вьюпорте
                        }
                        this.tbody.cancelSelection();
                        this.selectRow(this.tbody.rows[i + step]._model.get(this.keyField));
                        return;
                    }
                }
                this.scroll.changePosition(-step);
                this.tbody.cancelSelection();
                this.selectRow(messages[selectedMessageIndex + step][this.keyField]);
            }
        },

        selectNextPage: function () {
            this.scroll.changePosition((-1) * this.tbody.rows.length);
            this.tbody.cancelSelection();
            this.selectRow(this.tbody.rows[0]._model.get(this.keyField));
        },

        selectLastMessage: function () {
            var messages = this.messageHolder.getMessages();
            if (messages.length > 0) {
                this.tbody.cancelSelection();
                this.scroll.scrollToEnd();
                this.selectRow(messages[messages.length - 1][this.keyField]);
            }
        },

        selectRow: function (eventId, suppressWarning) {
            this.tbody.selectRow(eventId);
            this.messageHolder.selectMessage(eventId, suppressWarning);
        },

        confirmMessage: function (eventId, comment) {
            this.messageHolder.confirmMessage(eventId, comment);
        },      

        getPageRowsCount: function () {
            return this.tbody.rows.length;
        },        

        isDefaultSortOrder: function () {
            return  this.currentSortField == this.activeTimeField &&
                this.currentSortOrder === Enums.SortType.Desc;
        },

        scrollToMessage: function (message) {
            this.scroll.setMax(this.messageHolder._getMessageCount() - this.model.getPageMessageCount());
            if (this.scroll.visible) {
                this.scroll.setSliderPosition(message);
            }
        },
        scrollToNextPage: function () {
            this.scroll.changePosition((-1) * this.tbody.rows.length);
        },

        scrollToTop: function () {
            this.scroll.scrollToStart(0);
        }

    });

    return Grid;
});
