﻿// <copyright file="Table.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define([],
    function () {
        return function (that) {
            var keyField = 'EventId';
            var table = $$({
                _model: {},
                view: {
                    format: '<div class="grid-wrapper"><div class="journal-grid"><div class="journal-grid-viewport"><table></table></div></div></div>'
                },
                init: function (containerHeight) {
                    this.height = containerHeight;
                    this.scroll.init(this.getInnerHeight());
                    var ctx = this;
                    this.view.$('.journal-grid-viewport')
                        .mousewheel(function (e, delta) {
                            ctx.scroll.onMouseWheel(e, delta);

                            return false;
                        });
                    this.tbody.initRowRoughHeigth();
                    this.tbody.updateViewPortRows();
                },
                setHeight: function (height) {
                    this.height = height;
                    this.applyHeight();
                },

                applyHeight: function () {
                    if (this.visible) {
                        this.tbody.updateViewPortRows();
                        that.updateViewPort();
                    }
                },
                getInnerWidth: function () {
                    return this.view.$('.journal-grid-viewport')
                        .width();
                },
                getInnerHeight: function () {
                    return this.height - this.thead.getHeight();
                },
                updateViewPortHeight: function (height) {
                    this.view.$('.journal-grid-viewport').height(height + this.thead.getHeight());
                },

                show: function () {
                    this.view.$()
                        .show();
                    this.visible = true;
                },
                hide: function () {
                    this.view.$()
                        .hide();
                    this.visible = false;
                },
                applyColumnsStyles: function (columnsStyles) {
                    this.thead.applyHeadersStyles(columnsStyles);
                    this.tbody.applyRowsColumnsStyles(columnsStyles);
                },
                height: 0,
                visible: true,
                thead: null,
                tbody: null,
                scroll: null
            });

            return table;
        }
    });