﻿// <copyright file="Header.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Appearence'], function (Appearence) {

    return function (journalModel, messageHolder) {

        var thead = $$({
            _model: {
                eventId: 0
            },
            view: {
                format: '<thead><tr></tr></thead>'
            },
            getHeight: function () {
                return this.view.$()
                    .height();
            },
            applyHeadersStyles: function (columnsStyles) {
                for (var i = 0; i < columnsStyles.length; i++) {
                    this.headers[i].updateStyle(columnsStyles[i]);
                }
            },

            applyHeadersRowStyle: function (cssObj) {
                var backgroundColor = cssObj['BackgroundColor'];
                delete cssObj['BackgroundColor'];
                var view = this.view.$();
                view.css(cssObj);
                view.children('tr').css({ 'border-width': cssObj.borderWidth });

                Appearence.background.apply(view, backgroundColor);

                if (cssObj) {
                    view.children('th')
                        .children('div')
                        .height(cssObj.height);
                }
            },

            setSortColumn: function(columnName, sortOrder){
                this.headers.forEach(function (th) {
                    if (th._model.get('field') == columnName) {                       
                        th.currentSortOrder = sortOrder;
                        th.setAsSortColumn(sortOrder);
                    }
                }, this);
            },

            selectedHeader: null,
            headers: []
        });
      
        return thead;
    }
});