﻿// <copyright file="LabelController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


/*
* @class LabelController controller class for Label control
*/
define(['common/Enums', 'base/TextControlController', 'common/Appearence'], function (Enums, TextControlController,Appearence) {
    //here we will define controller for button

    var LabelController = TextControlController.extend({

        init: function () {
            this._super();

            this.modelChanged[Enums.ParameterRoles.SHADOW_SIZE] = this.onShadowChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHADOW_COLOR] = this.onShadowChanged.bind(this);

            this.ClassName = 'LabelController';
        },

        displayText: function () {
            var text = this.mvc.model.getDisplayValue();
            text = text != undefined ? text : "";

            this.textElement().text(text);
        },
        applyTextShadow: function () {
            var bg = this.mvc.model.getBackgroundColor();
            if (Appearence.color.parse(bg).brushType == "Solid" && Appearence.color.ARGBtoObj(bg).a == 0) {
                var textCol = this.mvc.model.getTextColor();
                if (textCol != "" && Appearence.color.ARGBtoObj(textCol).a != 0) {
                    Appearence.shadow.applyTextShadow(this.textElement(), {
                        color: this.mvc.model.getShadowColor(),
                        size: this.mvc.model.getShadowSize()
                    });
                } else {
                    this.textElement().css('text-shadow', "");
                }
            }
        },
        modelPropertyChangedInternal: function (event) {

            this._super(event);

            var value = this.mvc.model.get(event.property);

            switch (event.property) {
                case Enums.ParameterRoles.VALUE_FORMAT:
                    this.onValueFormatChanged(value);
                    break;
            }
        },

        onValueFormatChanged: function (value) {
            this.displayText();
        },

        onFontMultilineChanged: function (value) {
            var isMultiLine = this.mvc.model.get(Enums.ParameterRoles.FONT_MULTILINE);
            if (isMultiLine === true) {
                this.textElement().css('white-space', 'pre-wrap');
            } else {
                this.textElement().css('white-space', 'nowrap');
            }
        }
    });

    return LabelController;
});
