﻿define(['server/adapters/DataAdapter', 'server/ServerStateManager', 'server/Server', 'controls/Login/LoginType', 'helpers/PermissionChecker', 'core/L10n'],
    function (DataAdapter, ServerStateManager, Server, LoginType, PermissionChecker, L10n) {
    return function (callback) {
        return $$({
            _model: {
                id: 0,
                password: '',
                login: '',
                needLogin: true
            },
            view: {
                format:
            '<div class="outer">\
                <div class="login">\
                    <label id="loginLabel" for="login">Логин</label>\
                    <select id="login" data-bind="login"></select>\
                    <label id="passwordLabel" for="password">Пароль</label>\
                    <input id="password" type="password" data-bind="password"/>\
                    <span></span>\
                    <button class="loginbtn btn">Login</button>\
                </div>\
            </div>'
            },
            _controller: {
                create: function() {
                    Server.init(LoginType.RequestServerPrefix);
                    this.client = new DataAdapter(new ServerStateManager());
                    $('body').on('keypress', function (e) {
                        if (e.keyCode === 13) {
                            var params = this._controller.getCredentialsFromControls();
                            this._controller.doLogin(params.user, params.password);
                        }
                    }.bind(this));
                },

                getLoginData: function () {
                    return this.client.getLoginData().then(function (responce) {
                        responce = responce.data;
                        // already have session token
                        // OR operators array is not defined
                        // OR operators array is empty
                        if ((responce.currentOperator && responce.currentOperator.length > 0)
                            || !(responce.hasOwnProperty('operators'))
                            || responce.operators.length === 0) {
                            this._model.set({ needLogin: false });
                            callback(responce);
                            PermissionChecker.setOperator(responce.currentOperator);
                            this._controller.destroyInternal();
                        } else {
                            this._model.set({ needLogin: true });
                            this._controller.createControl(responce.operators);
                        }
                    }.bind(this));
                },

                createControl: function (operators) {
                    var option,
                        select = this.view.$('select')[0];
                    for (var i = 0; i < operators.length; ++i) {
                        option = document.createElement('OPTION');
                        option.innerHTML = operators[i].login;
                        option.setAttribute('value', operators[i].login);
                        select.appendChild(option);
                    }

                    L10n.setLocale(LoginType.Language).then(function () {
                        this.view.$('.loginbtn').text(L10n.get('controls.loginButton'));
                        this.view.$('#loginLabel').text(L10n.get('controls.loginLabel'));
                        this.view.$('#passwordLabel').text(L10n.get('controls.passwordLabel'));
                    }.bind(this));
                    var params = this._controller.getCredentialsFromUrl();
                    if (params) {
                        this._controller.doLogin(params.user, params.password);
                        return;
                    }
                },
                'click button': function () {
                    var params=this._controller.getCredentialsFromControls();
                    this._controller.doLogin(params.user, params.password);
                },

                doLogin: function (login, password) {
                    this.client.login(login, password).then(function (responce) {
                        callback(responce.data);
                        PermissionChecker.setOperator(responce.parameters.login);
                        this._controller.destroyInternal();
                    }.bind(this), function (error) {
                        this.view.$('span').text(error);
                    }.bind(this));
                },
                getCredentialsFromControls: function(){
                    // потому что хром не умеет в датабиндинг одного итема в <select>
                    var login = this.view.$('select option:selected')
                        .first()
                        .attr('value'),

                    password = this.view.$("#password").val();
                    if (password != "") {
                        password = CryptoJS.MD5(password).toString(CryptoJS.enc.Hex);
                    }
                    return { user: login, password: password };
                },
                getCredentialsFromUrl: function(){
                    var params = document.location.href.queryStringToJSON();
                    if (params && params.user && params.password) {
                        return { user: params.user, password: CryptoJS.MD5(params.password.toString()).toString(CryptoJS.enc.Hex) };
                    } else {
                        return null;
                    }
                },
                needLogin: function () {
                    return this._model.get('needLogin');
                },

                destroyInternal: function () {
                    $('body').off('keypress');
                    this.destroy();
                }
            }
        });
    }
})