﻿// <copyright file="MessageIndicatorController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ControlController',
        'common/Appearence','server/requestManager/RequestManager',
        'core/actions/OpenJournalAction', 'core/WindowsManager',
        'common/Error', 'controls/ControlTypeFactory', 'core/L10n'],
        function (Enums, ControlController,
     Appearence, RequestManager, OpenJournalAction, WindowsManager, Error, ControlTypeFactory, L10n) {

    var MessageIndicatorController = ControlController.extend({

        init: function () {
            this._super();
            this.messages = [];
            this.ClassName = 'MessageIndicatorController';
            this.initialized = false;
        },

        onAddedToDOM: function () {
            this._addOpenJournalAction();
            this.requestManager = this._createRequestManager();
            this.requestManager.subscribe();
            this.initialized = true;
            this._setNoNewMessagesIcon();
        },

        onDestroy: function () {
            this._super();
            this.requestManager.unsubscribe();
            this.initialized = false;
        },

        onClick: function (event) {
            this._super(event);
            if (WindowsManager.getWindowModelById(this.mvc.model.getDataSource()) === undefined) {
                Error.warn(L10n.get('messages.noJournal'));
                return;
            }

            this.openDialogAction.execute(this);
            this._setNoNewMessagesIcon();
        },

        onResourceChanged: function (value) {
            //не применяем - испольуем свою иконку
        },

        _setNewMessageIcon: function () {
            Appearence.background.applyBgImage(this.mvc.view.$(),
                'scripts/controls/MessageIndicator/styles/images/new_messages.png');
        },

        _setNoNewMessagesIcon: function () {
            Appearence.background.applyBgImage(this.mvc.view.$(),
                'scripts/controls/MessageIndicator/styles/images/no_messages.png');
        },

        _createRequestManager: function () {
            var requestManager = new RequestManager(this.mvc.model.getOptionsForEM());           
            requestManager.setFilters(this.mvc.model.getFiltersForEM(), true);
            requestManager.setColumns(this.mvc.model.getColumnsForEM());
            requestManager.subscribeMessagesChanged(this._onNewMessagesReceived, this);

            return requestManager;
        },

        _onNewMessagesReceived: function (event) {
            var i;
            for (i = 0; i < event.newOrUpdated.length; i++) {
                if (this.messages.indexOf(event.newOrUpdated[i].EventId) == -1) {
                    this.messages.push(event.newOrUpdated[i].EventId);
                }
            }
            for (i = 0; i < event.deleted.length; i++) {
                var indexToDelete = this.messages.indexOf(event.deleted[i])
                this.messages.splice(indexToDelete, 1);
            }
            if (this.messages.length > 0) {
                this._setNewMessageIcon();
                this.mvc.model.set(Enums.ParameterRoles.HAS_MESSAGES, true);
            } else {
                this.mvc.model.set(Enums.ParameterRoles.HAS_MESSAGES, false);
                this._setNoNewMessagesIcon();
            }

        },
        _addOpenJournalAction: function () {
            var options = {};          
            var windowModeloriginal = WindowsManager.getWindowModelById(this.mvc.model.getDataSource());
            if (windowModeloriginal === undefined) {
            //    Error.warn(L10n.get('messages.noJournal'));
                return;
            }

            this.openDialogAction = new OpenJournalAction({
                id: this.mvc.model.getId() + '_openJournal',
                type: Enums.ActionType.openDialog,
                constants: {
                    WindowId: this.mvc.model.getDataSource(),
                    CanMinimize: true,
                    CanResize: true,                   
                    Behaviour: Enums.SizeToContentType.RealSize,
                    Title: "",
                    Background: "#FFE0E0FF"
                },
                parameters: {}
            });

            var journalWrapperType = $.extend(true, {}, ControlTypeFactory.getType(windowModeloriginal.typeName));
            $.extend(true, journalWrapperType.childModels[0].parameters, {
                Filters: this.mvc.model.getFiltersProperty(),
                ObjectUID: this.mvc.model.getObjectUIDProperty()
            });

            this.openDialogAction.addTypeReplaceParameters(journalWrapperType);
            this.openDialogAction.replaceModelParams(this.openDialogAction.constants);
            if (windowModeloriginal.parameters.Width.value < 800) {
                var width = this.mvc.model.getProperty(Enums.ParameterRoles.WIDTH);
                width.value = 800;
                this.openDialogAction.addReplacedParameter({ Width: width });
            }
        }
    });

    return MessageIndicatorController;
});
