﻿// <copyright file="NumericUpDownModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class NumericUpDownModel model class for NumericUpDown control
*/

define(['common/Enums', 'base/TextEditModel'],
function (Enums, TextEditModel) {
    //here we will define model for button


    var NumericUpDownModel = TextEditModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'NumericUpDownModel';

        },

        getValue: function () {
            return this.get(Enums.ParameterRoles.VALUE);
        },

        setValue: function (value) {
            this.set(Enums.ParameterRoles.VALUE, value);
        },

        getMinValue: function () {
            return this.get(Enums.ParameterRoles.MIN_VALUE);
        },

        getMaxValue: function () {
            return this.get(Enums.ParameterRoles.MAX_VALUE);
        },

        getIncrementStep: function () {
            return this.get(Enums.ParameterRoles.INCREMENT_STEP);
        }
    });

    return NumericUpDownModel;
});
