﻿// <copyright file="SchemeModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ContainerModel', 'core/convertations/ConvertationTypes'],
    function (Enums, ContainerModel, ConvertationTypes) {
    //here we will define model for whole scheme
    //this file will be generated by app

    var SchemeModel = ContainerModel.extend({

        init: function (type) {            
			ConvertationTypes.init(type.convertationTypes);
			this._super(type);
			this.tasks = $.extend([], type.tasks);			
    	    //схема - root элемент
    	    //в теории для него не должно быть параметров
    	    //но на практике они нужны для корректной отработки
            //параметров дочерних окон
			this._data["Width"] = {
			    "typeName": "REAL",
			    "typeHash": 1,
			    "value": 0
			}
			this._data["Height"] = {
			    "typeName": "REAL",
			    "typeHash": 1,
			    "value": 0
			}
            this._data["WidthType"] = {
                "typeName": "REAL",
                "typeHash": 1,
                "value": "pixels"
            }
            this._data["HeightType"] = {
                "typeName": "REAL",
                "typeHash": 1,
                "value": "pixels"
            };

            this._data[Enums.ParameterRoles.IS_VISIBLE] = {
                "typeName": "BOOL",
                "typeHash": 3,
                "value": true
            }
            this._data[Enums.ParameterRoles.ID] ={
                "typeName": "STRING",
                "typeHash": 1,
                "value": "schema"
            };
            this._data[Enums.ParameterRoles.BORDER_THIKNESS] = {
                "typeName": "REAL",
                "typeHash": 1,
                "value": 0
            }
            this._data[Enums.ParameterRoles.Y] = {
                "typeName": "REAL",
                "typeHash": 1,
                "value": 0
            }
            this._data[Enums.ParameterRoles.X] = {
                "typeName": "REAL",
                "typeHash": 1,
                "value": 0
            }
            this._data[Enums.ParameterRoles.ROLE] = {
                "typeName": "STRING",
                "typeHash": 4,
                "value": "Schema"
            }
            this._data[Enums.ParameterRoles.IS_ENABLED] = {
                "typeName": "BOOL",
                "typeHash": 3,
                "value": true
            }
            
            this.ClassName = 'SchemeModel';
    	},


    	getStartScreen: function () {
    	    return this.get(Enums.ParameterRoles.START_SCREEN);
    	},

    	hasStartScreen: function () {
    	    return this.getStartScreen() !== '';
    	},

    	getTasks: function () {
    	    return this.tasks;
    	}
    });

    return SchemeModel;
});
