﻿// <copyright file="TabControlModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class TabControlModel model class for TabControl control
*/
define(['common/Enums', 'base/ContainerModel'],
function (Enums, ContainerModel) {

    var TabControlModel = ContainerModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'TabControlModel';
        },

        getLayout: function () {
            return this.get(Enums.ParameterRoles.LAYOUT);
        },

        getOrientation: function () {
            return this.get(Enums.ParameterRoles.ORIENTATION);
        },

        getLoadInvisibleContent: function () {
            return this.get(Enums.ParameterRoles.LOAD_INVISIBLE_CONTENT);
        },

        getTextColor: function () {
            return this.get(Enums.ParameterRoles.TEXT_COLOR);
        },

        getTextShadowColor: function () {
            return this.get(Enums.ParameterRoles.TEXT_SHADOW_COLOR);
        },

        getTextShadowSize: function () {
            return this.get(Enums.ParameterRoles.TEXT_SHADOW_SIZE);
        },

        getFontName: function () {
            return this.get(Enums.ParameterRoles.FONT_NAME);
        },

        getFontSize: function () {
            return 14;
            //return this.get(Enums.ParameterRoles.FONT_SIZE);
        },

        getFontBold: function () {
            return this.get(Enums.ParameterRoles.FONT_BOLD);
        },

        getFontItalic: function () {
            return this.get(Enums.ParameterRoles.FONT_ITALIC);
        },

        getFontUnderlined: function () {
            return this.get(Enums.ParameterRoles.FONT_UNDERLINED);
        }
    });

    return TabControlModel;
});
