﻿// <copyright file="TrendModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class TrendModel model class for Trend control
*/
define(['common/Enums', 'base/ControlModel'],
function (Enums, ControlModel) {

    var TrendModel = ControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);
            this.timePoints = [];
            this.ClassName = 'TrendModel';
            this.previousInterval = 0;
        },

        getOptions: function() {
            return {
                Trendlines: this.get(Enums.ParameterRoles.TREND_LINES),                
                grid: {
                    color: this.get(Enums.ParameterRoles.CHART_BACKGROUND),
                    line: {
                        thickness: this.get(Enums.ParameterRoles.GRID_LINE_THICKNESS),
                        strokeColor: this.get(Enums.ParameterRoles.GRID_LINE_STROKE_COLOR),
                        fillColor: this.get(Enums.ParameterRoles.GRID_LINE_FILL_COLOR)                      
                    }
                },
                xAxis: {
                    strokeColor: this.get(Enums.ParameterRoles.X_AXIS_STROKE_COLOR),
                    fillColor: this.get(Enums.ParameterRoles.X_AXIS_FILL_COLOR),
                    majorTick: {
                        width: this.get(Enums.ParameterRoles.X_MAJOR_TICK_WIDTH),
                        height: this.get(Enums.ParameterRoles.X_MAJOR_TICK_HEIGHT),                     
                        padding: {
                            left: this.get(Enums.ParameterRoles.X_MAJOR_TICK_PADDING_LEFT),
                            right: this.get(Enums.ParameterRoles.X_MAJOR_TICK_PADDING_RIGHT),
                            bottom: this.get(Enums.ParameterRoles.X_MAJOR_TICK_PADDING_BOTTOM),
                            top: this.get(Enums.ParameterRoles.X_MAJOR_TICK_PADDING_TOP)
                        },
                        color: this.get(Enums.ParameterRoles.X_MAJOR_TICK_COLOR)
                    },
                    minorTick: {
                        width: this.get(Enums.ParameterRoles.X_MINOR_TICK_WIDTH),
                        height: this.get(Enums.ParameterRoles.X_MINOR_TICK_HEIGHT),
                        color: this.get(Enums.ParameterRoles.X_MINOR_TICK_COLOR)
                    },
                    majorTicksCount: this.get(Enums.ParameterRoles.X_MAJOR_TICK_COUNT),
                    minorTicksCount: this.get(Enums.ParameterRoles.X_MINOR_TICK_COUNT),
                    arrow: {
                        width: this.get(Enums.ParameterRoles.X_ARROW_WIDTH),
                        height: this.get(Enums.ParameterRoles.X_ARROW_HEIGHT),
                        padding: {
                            left: this.get(Enums.ParameterRoles.X_ARROW_MARGIN)
                        },
                        fillColor: this.get(Enums.ParameterRoles.X_ARROW_FILL_COLOR),
                        strokeColor: this.get(Enums.ParameterRoles.X_ARROW_STROKE_COLOR)                        
                    },
                    thickness: this.get(Enums.ParameterRoles.X_AXIS_THICKNESS),                                      
                    format: this.get(Enums.ParameterRoles.X_AXIS_FORMAT),
                    interval: this.get(Enums.ParameterRoles.INTERVAL),
                    textColor: this.get(Enums.ParameterRoles.TEXT_COLOR),
                    dateOffset: 5,
                    dateWrap: true
                },

                yAxis: {
                    strokeColor: this.get(Enums.ParameterRoles.Y_AXIS_STROKE_COLOR),
                    fillColor: this.get(Enums.ParameterRoles.Y_AXIS_FILL_COLOR),
                    majorTick: {
                        width: this.get(Enums.ParameterRoles.Y_MAJOR_TICK_WIDTH),
                        height: this.get(Enums.ParameterRoles.Y_MAJOR_TICK_HEIGHT),
                        padding: {
                            left: this.get(Enums.ParameterRoles.Y_MAJOR_TICK_PADDING_LEFT),
                            right: this.get(Enums.ParameterRoles.Y_MAJOR_TICK_PADDING_RIGHT),
                        },
                        color: this.get(Enums.ParameterRoles.Y_MAJOR_TICK_COLOR),
                    },
                    minorTick: {
                        width: this.get(Enums.ParameterRoles.Y_MINOR_TICK_WIDTH),
                        height: this.get(Enums.ParameterRoles.Y_MINOR_TICK_HEIGHT),
                        color: this.get(Enums.ParameterRoles.Y_MINOR_TICK_COLOR)
                    },
                    majorTicksCount: this.get(Enums.ParameterRoles.Y_MAJOR_TICK_COUNT),
                    minorTicksCount: this.get(Enums.ParameterRoles.Y_MINOR_TICK_COUNT),
                    arrow: {
                        width: this.get(Enums.ParameterRoles.Y_ARROW_WIDTH),
                        height: this.get(Enums.ParameterRoles.Y_ARROW_HEIGHT),
                        padding: {
                            bottom: this.get(Enums.ParameterRoles.Y_ARROW_MARGIN)
                        },
                        fillColor: this.get(Enums.ParameterRoles.Y_ARROW_FILL_COLOR),
                        strokeColor: this.get(Enums.ParameterRoles.Y_ARROW_STROKE_COLOR)
                    },
                    thickness: this.get(Enums.ParameterRoles.Y_AXIS_THICKNESS),
                    textColor: this.get(Enums.ParameterRoles.TEXT_COLOR),
                    min: Number.POSITIVE_INFINITY,
                    max: Number.NEGATIVE_INFINITY,
                    format: '{0:n5}'
                },
                verticalCursor: {
                    interval: this.get(Enums.ParameterRoles.INTERVAL)
                }
            };
        },

        getPens: function () {
            return this.get(Enums.ParameterRoles.TREND_LINES) || [];
        },      

        getPen: function (index) {
            return this.getPens()[index];
        },

        getPenColor: function (index) {
            return this.getPen(index)[Enums.ParameterRoles.COLOR].value;
        },
        getPenName: function (index) {
            return this.getPen(index)[Enums.ParameterRoles.NAME].value;
        },
        getPenValueObject: function (index) {
            var pen = this.getPen(index);
            return {
                format: pen[Enums.ParameterRoles.Y_FORMAT].value,
                value: pen[Enums.ParameterRoles.DATA_SOURCE].value
            };
        },

        getIsAutoScale: function () {
            return this.get(Enums.ParameterRoles.AUTOSCALE);
        },
        getIsAutoScroll: function () {
            return this.get(Enums.ParameterRoles.AUTOSCROLL);
        },

        stopAutoscroll: function () {
            if (this.getIsAutoScroll())
               this.set(Enums.ParameterRoles.AUTOSCROLL, false);
        },

        getYAxisRangeFactor: function () {
            return 0.1;
        },

        getFreezeCursor: function () {
            return this.get(Enums.ParameterRoles.FREEZE_CURSOR);
        },

        getInterval: function () {
            return this.get(Enums.ParameterRoles.INTERVAL);
        },

        getXMajorTickCount: function () {
            return this.get(Enums.ParameterRoles.X_MAJOR_TICK_COUNT);            
        },

        getXMajorTickColor: function(){
            return this.get(Enums.ParameterRoles.X_MAJOR_TICK_COLOR);
        },

        getXMajorTickWidth: function () {
            return this.get(Enums.ParameterRoles.X_MAJOR_TICK_WIDTH);
        },

        getXMajorTickHeight: function () {
            return this.get(Enums.ParameterRoles.X_MAJOR_TICK_HEIGHT);
        },

        getXMinorTickColor: function () {
            return this.get(Enums.ParameterRoles.X_MINOR_TICK_COLOR);
        },

        getXMinorTickWidth: function () {
            return this.get(Enums.ParameterRoles.X_MINOR_TICK_WIDTH);
        },

        getXMinorTickHeight: function () {
            return this.get(Enums.ParameterRoles.X_MINOR_TICK_HEIGHT);
        },     

        getYMajorTickColor: function () {
            return this.get(Enums.ParameterRoles.Y_MAJOR_TICK_COLOR);
        },

        getYMajorTickWidth: function () {
            return this.get(Enums.ParameterRoles.Y_MAJOR_TICK_WIDTH);
        },

        getYMajorTickHeight: function () {
            return this.get(Enums.ParameterRoles.Y_MAJOR_TICK_HEIGHT);
        },

        getYMinorTickColor: function () {
            return this.get(Enums.ParameterRoles.Y_MINOR_TICK_COLOR);
        },

        getYMinorTickWidth: function () {
            return this.get(Enums.ParameterRoles.Y_MINOR_TICK_WIDTH);
        },

        getYMinorTickHeight: function () {
            return this.get(Enums.ParameterRoles.Y_MINOR_TICK_HEIGHT);
        },

        setInterval: function (value, source) {
            if (value <= 0) {
                value = 100;
            }
            if (source !== Enums.ParametersSource.gesture) {
                this.previousInterval = this.getInterval();
            };

            return this.set(Enums.ParameterRoles.INTERVAL, value);
        },

        resetInterval: function (interval) {
            if (this.previousInterval !== 0) {
                return this.set(Enums.ParameterRoles.INTERVAL, interval);
            }
        },

        enableAutoscroll: function () {
            this.set(Enums.ParameterRoles.AUTOSCROLL, true);
        },

        getMaxCurosorsCount: function () {
            return 1;
        },

        getIsEnabled: function () {
            return this.get(Enums.ParameterRoles.IS_ENABLED);
        },

        setProperty: function (name, newProperty, silent, force) {
            this._super(name, newProperty, silent, true);
        }
    });

    return TrendModel;
});
