// <copyright file="CanvasPool.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['base/ObservableObject', 'common/Error', 'controls/Trend/modules/Canvas'],

    function (ObservableObject, Error, Canvas) {

    var CanvasPool = ObservableObject.extend({
       
        init: function () {
            this._super();
            this.canvasPoolArray = [];
            this._freeCanvases = [];
        },

        requestCanvas: function () {
            //index - положение в cavasPoolArray, он же id канваса
            if (this._freeCanvases.length == 0) {
                var index = this.canvasPoolArray.length;
                var canvas = new Canvas(index, this.dispatcher.bind(this));
                this.canvasPoolArray.push(canvas);
            } else {
                var canvas = this._freeCanvases.pop();
            }

            return canvas;
        },

        returnCanvas: function (canvas) {
            if (this.checkCanvas(canvas)) {
                canvas.beginRender();
                canvas.clear();
                canvas.endRender();
                canvas.removeAllListeners();
                this._freeCanvases.push(canvas);
            }
        },

        checkCanvas: function(canvas){
            if (canvas === null) {
                Error.onerror("CanvasPool: Null object was returned to pool");
                return false;
            }

            if (canvas.id > (this.canvasPoolArray.length - 1)) {
                Error.onerror("CanvasPool: canvas " + canvas.id + " is not exist in canvas pool");
                return false;
            }

            return true;
        },
        dispose: function() {
            for (var i = 0; i < this.canvasPoolArray.length; ++i) {
                this.canvasPoolArray[i].dispose();
            }

            this.canvasPoolArray = [];
            this._freeCanvases = [];
        },

        dispatcher: function (id, eventType, event) {
            for (var i = 0; i < this.canvasPoolArray.length; ++i) {
                if (id !== this.canvasPoolArray[i].id) {
                    this.canvasPoolArray[i]._processEvent(eventType, event);
                }
                else { break; }
            }
        },

        
    });     

    return CanvasPool;
});