﻿// <copyright file="StaticVerticalCursor.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// <author>Bogdan Nosachenko b.nosachenko@infostroy-software.com</author>

define(['common/Enums', 'controls/Trend/modules/Alghoritms', 'common/Appearence', 'controls/Trend/modules/VerticalCursor'],
    function (Enums, Alghoritms, Appearence, VerticalCursor) {
        
        var StaticVerticalCursor = VerticalCursor.extend({
            // options used for drawing
            options: {
                valuePadding: 35,
                borderHeihgt: 10,
                borderWidth: 32,
                cursorArea: 5
            },

            init: function (canvas, model, backLayerCanvas, backLayerXAxis) {

                this.model = model;
                this.canvas = canvas;
                this.backLayerCanvas = backLayerCanvas;
                this.backLayerXAxis = backLayerXAxis;
                this.xCoordsLable = 0;
            },

            drawVerticalLine: function (dimensions, serverMark, mark) {
                var parsedColor = Appearence.color.ARGBtoObj(this.model.get(Enums.ParameterRoles.CURSOR_CUT_COLOR)),
                    strokeColor = Appearence.color.objToCSS(parsedColor),
                    height = dimensions.height,
                    width = dimensions.width,
                    x = Alghoritms.getScreenX(serverMark, this.model.getInterval(), mark, width);

                var lineWidth = this.model.get(Enums.ParameterRoles.CURSOR_THICKNESS);
                // we want to avoid subpixel rendering when drawing line
                if (lineWidth === 1) {
                    lineWidth = 2;
                }
                if (x > dimensions.width) {
                    return;
                }
                this.canvas.drawLine({
                    x1: x,
                    x2: x,
                    y1: 0,
                    y2: height,
                    strokeStyle: strokeColor,
                    lineWidth: lineWidth
                });
            },

            drawCursor: function (dimensions, serverMark, mark, data, selectLine) {
                var parsedColor = Appearence.color.ARGBtoObj(this.model.get(Enums.ParameterRoles.CURSOR_CUT_COLOR)),
                    strokeColor = Appearence.color.objToCSS(parsedColor),
                    height = dimensions.height,
                    width = dimensions.width,
                    bounds = { lowBound: data.length - 2, highBound: data.length - 1 },
                    x = Alghoritms.getScreenX(serverMark, this.model.getInterval(), mark, width);
                if (x > dimensions.width)
                    return;
                this.maxBufferCanvasSize = this.canvas.getSize().width;

                if (bounds.lowBound === -1) {
                    return;
                }

                if (bounds.lowBound === bounds.highBound) {
                    bounds.lowBound = Math.max(0, bounds.lowBound - 1);
                    bounds.highBound = Math.min(data.length - 1, bounds.highBound + 1);
                }

                // range for each graph
                var range = {
                    0: selectLine.model.getMin(),
                    1: selectLine.model.getMax()
                }

                var trendlineSegmentStart = this._getLineSegment(data[bounds.lowBound], mark, width, height, range),
                    trendlineSegmentEnd = this._getLineSegment(data[bounds.highBound], mark, width, height, range);
                             

                var intersectionPoint = Alghoritms.getIntersection(trendlineSegmentStart,
                    trendlineSegmentEnd, { x: x, y: 0 }, { x: x, y: height });                    

                if ((isNaN(intersectionPoint[0]) || isNaN(intersectionPoint[1])) && data[data.length - 1]) {
                    var lastPointX = Alghoritms.getScreenX(data[data.length - 1],
                        this.model.getInterval(), mark, width);

                    //данные всегда будут на доли секунды отставать от серверного
                    //времени, поэтому во избежание миганий допускаем 
                    // неточное соприкосновение
                    if ((lastPointX - x) > this.options.cursorArea) {
                        return;
                    }

                    intersectionPoint[1] = trendlineSegmentEnd.y;                    
                }

                y = Alghoritms.getY(intersectionPoint[1], height, range);
                this.xCoordsLable = x + 4 * this.model.get(Enums.ParameterRoles.CURSOR_THICKNESS);
                var text = (y.toFixed(2)).toString();
                this.options.borderWidth = this.canvas.measureText(text)+2;
                this._drawLabelBorder(this.xCoordsLable, intersectionPoint[1]+1, selectLine);
                this.canvas.setFillStyle(Appearence.color.toCssColor(this.model.get(Enums.ParameterRoles.CURSOR_CUT_COLOR)));
                this.canvas.fillText({
                    x: this.xCoordsLable,
                    y: intersectionPoint[1],
                    text: y.toFixed(2)
                });
                
               // this.backLayerCanvas.endRender();

                return x;
            },

            _drawLabelBorder: function (x, y, selectLine) {
                var border = {};
                border.width = this.options.borderWidth;
                border.height = this.options.borderHeihgt;
                border.x = x - 2;
                border.y = y - border.height;
                border.strokeStyle = selectLine.model.isSelected ? selectLine.model.getSelectionColor() : selectLine.model.getLineColor();
                border.fillStyle = Appearence.color.toCssColor(this.model.get(Enums.ParameterRoles.CHART_BACKGROUND));
                this.canvas.drawRect(border);

                border = null;
            },

            _getLineSegment: function (item, mark, width, height, range) {
                return Alghoritms.getPointScreenCoords(item, this.model.getInterval(), mark, width, height, range);
            },

        });
        return StaticVerticalCursor;
    });