﻿

define(['base/Model', 'common/Enums'], function (Model, Enums) {

    // options used for drawing
    var defaults = {
        checkbox: {
            padding: {
                left: 5,
                top: 5,
                bottom: 5,
                right: 5
            }
        },
        value: {
            padding: {
                left: 5,
                top: 5,
                bottom: 5,
                right: 5
            }
        },
        name: {
            padding: {
                left: 5,
                top: 5,
                bottom: 5,
                right: 5
            }
        },

        padding: {
            left: 5,
            top: 5,
            bottom: 5,
            right: 5
        }
    };

    var MiniLegendModel = Model.extend({
        init: function (trendModel) {
            this._super();
            this.style = {};
            this._data = trendModel;
            $.extend(true, this.style, defaults);
        },

        getTrendline: function (idx) {
            return this._data[idx];
        },

        getTrendLineVisiblity: function(idx){
            return this.getTrendline(idx).value[Enums.ParameterRoles.IS_VISIBLE].value;
        },
        getTrendlineProperty: function (idx, property) {
            return this._data[idx].value[property].value;
        },

        getTrendlines: function () {
            return this._data;
        }
    });

    return MiniLegendModel;

});