﻿// <copyright file="Graph.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>


define(['base/Model', 'common/Enums'], function (Model, Enums) {

    var TrendlineModel = Model.extend({

        init: function (idx, model) {
            this._super();
            this.idx = idx;
            this._data = model;
            this.isSelected = false;
            this.isDataStoring = true;
            this.defaultColor = 'black';
        },

        getStyleSettings: function () {
            return {
                min: this.get(Enums.ParameterRoles.MIN_Y),
                max: this.get(Enums.ParameterRoles.MAX_Y),
                majorTicksCount: this.get(Enums.ParameterRoles.TICK_COUNT_Y),
                format: this.get(Enums.ParameterRoles.Y_FORMAT)
            };
        },

        setMinY: function(value){
            return this.set(Enums.ParameterRoles.MIN_Y, value);
        },

        setMaxY: function (value) {
            return this.set(Enums.ParameterRoles.MAX_Y, value);
        },

        getIsVisible: function () {
            return this.get(Enums.ParameterRoles.IS_VISIBLE);
        },

        setIsVisible: function (value) {
            return this.set(Enums.ParameterRoles.IS_VISIBLE, value);
        },

        getId: function () {
            return this.idx;
        },

        getMin: function () {
            return this.get(Enums.ParameterRoles.MIN_Y);
        },

        getMax: function () {
            return this.get(Enums.ParameterRoles.MAX_Y);
        },

        getRange: function () {
            return [this.getMin(), this.getMax()];
        },

        getBorders: function () {
            return this.get(Enums.ParameterRoles.TREND_LIMITS);
        },
        //--
        getLineJoin: function () {
            return this.get(Enums.ParameterRoles.LINE_JOIN);
        },
        getLineColor: function () {           
            return this.get(Enums.ParameterRoles.COLOR) || this.defaultColor;
        },

        getThickness: function () {
            return this.get(Enums.ParameterRoles.LINE_WIDTH);
        },

        getSelectionColor: function () {
            return this.get(Enums.ParameterRoles.SELECTION_COLOR) || this.defaultColor;
        },

        getFalseyValuesLinestyle: function(){
            return this.get(Enums.ParameterRoles.FALSEY_VALUES_LINESTYLE);
        },

        drawIfNoData: function () {
            return this.get(Enums.ParameterRoles.DRAW_CONSTANT);
        }

    });

    return TrendlineModel;
});