// <copyright file="ActionFactory.js" company="">
// , 2014
// </copyright>
// 

define(['common/Enums', 'core/actions/AlertAction', 'core/actions/CallPOUAction',
    'core/actions/ChangeConditionStateAction', 'core/actions/SetParameterValueAction',
'core/actions/OpenWindowAction', 'core/actions/OpenDialog/OpenDialogAction',
'core/actions/LoginAction', 'core/actions/LogoutAction', 'core/actions/CallEventAction',
'core/actions/CallMethodAction', 'core/actions/FullScreenAction', 'core/actions/CloseDialogAction',
'core/actions/BackwardAction', 'core/actions/ForwardAction', 'core/actions/ShowTaskBarAction', 'core/actions/OpenPrintDialogAction', 'core/actions/OpenUrlAction'],
function (Enums, AlertAction, CallPOUAction, ChangeConditionStateAction,
    SetParameterValueAction, OpenWindowAction, OpenDialogAction,
    LoginAction, LogoutAction, CallEventAction, CallMethodAction, FullScreenAction, CloseDialogAction,
    BackwardAction, ForwardAction, ShowTaskBarAction, OpenPrintDialogAction, OpenUrlAction) {
    function ActionFactory() {

    };

    ActionFactory.prototype.createByType = function (options) {
        switch (options.type) {
            case Enums.ActionType.alert:
                return new AlertAction(options);
                break;
            case Enums.ActionType.callPOU:
                return new CallPOUAction(options);
                break;
            case Enums.ActionType.changeConditionState:
                return new ChangeConditionStateAction(options);
                break;
            case Enums.ActionType.setParameterValue:
                return new SetParameterValueAction(options);
                break;
            case Enums.ActionType.openWindow:
                return new OpenWindowAction(options);
                break;
            case Enums.ActionType.openDialog:
                return new OpenDialogAction(options);
                break;
            case Enums.ActionType.openPrintDialog:
                return new OpenPrintDialogAction(options);
                break;
            case Enums.ActionType.login:
                return new LoginAction(options);
                break;
            case Enums.ActionType.logout:
                return new LogoutAction(options);
                break;
            case Enums.ActionType.callEvent:
                return new CallEventAction(options);
                break;
            case Enums.ActionType.callMethod:
                return new CallMethodAction(options);
                break;
            case Enums.ActionType.fullScreen:
                return new FullScreenAction(options);
                break;
            case Enums.ActionType.closeDialog:
                return new CloseDialogAction(options);
                break;
            case Enums.ActionType.backward:
                return new BackwardAction(options);
                break;
            case Enums.ActionType.forward:
                return new ForwardAction(options);
                break;
            case Enums.ActionType.showTaskBar:
                return new ShowTaskBarAction(options);
                break;
            case Enums.ActionType.openUrl:
                return new OpenUrlAction(options);
                break;

        }
    };

    var instance = new ActionFactory();
    return instance;
})