define(['core/adapters/SchemeAdapter',
'core/adapters/MasterPLCAdapter',
'core/adapters/ActionAdapter',
'core/adapters/StaticValueAdapter',
'core/adapters/ConditionAdapter',
'core/adapters/EventAdapter',
'core/adapters/SvgAdapter',
'core/adapters/FunctionBlockAdapter',
'core/adapters/ProtocolTaskAdapter',
'common/Enums'], function (
	SchemeAdapter,
	MasterPLCAdapter,
	ActionAdapter, 
	StaticValueAdapter,
    ConditionAdapter,
    EventAdapter,
    SvgAdapter,
    FunctionBlockAdapter,
    ProtocolTaskAdapter,
	enums) {

	function AdapterFactory() {

	};

	AdapterFactory.prototype.getByType = function(type) {
		switch(type) {
		    case enums.connectionType.client:
		        return SchemeAdapter;
		    case enums.connectionType.svg:
		        return SvgAdapter;
				break;
			case enums.connectionType.server:
				return MasterPLCAdapter;
				break;
		    case enums.connectionType.event:
		        return EventAdapter;
		        break;
		    case enums.connectionType.action:
		        return ActionAdapter;
		        break;
			case enums.connectionType.static:
		        return StaticValueAdapter;
		        break;
		    case enums.connectionType.condition:
		        return ConditionAdapter;
		        break;
		    case enums.connectionType.functionBlock:
		        return FunctionBlockAdapter;
		        break;
		    case enums.connectionType.protocolTask:
		        return ProtocolTaskAdapter;
		}
	};

	var instance = new AdapterFactory();
	return instance;
})