﻿// <copyright file="WindowsManager.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['base/ObservableObject', 'common/Error', 'js!libs/history.js!order', 'js!libs/history_adapter_jquery.js!order'], function (ObservableObject, Error) {
    var ACTIVE_WINDOW_CHANGED = 'activeWindowModelChanged';

    // Prepare
    var History = window.History; // Note: We are using a capital H instead of a lower h

    //VictorM В WebView на Android почему-то срабатывает проверка
    //if (!History.enabled) {
    //    // History.js is disabled for this browser.
    //    // This is because we can optionally choose to support HTML4 browsers or not.
    //    return false;
    //};

    var WindowsManager = ObservableObject.extend({
        prefix: 'window',
        print: 'print',
        windowsModels: [],
        activeWindowModel: null,

        init: function () {
            this._super();
            // Bind to StateChange Event
            if (History.enabled)
                History.Adapter.bind(window, 'statechange', function () { // Note: We are using statechange instead of popstate
                    var State = History.getState();
                    //first page has no state
                    if (State.data.state === undefined) {
                        this.setActiveWindowModelById(this.getDefaultWindowId(), null, true);
                    } else {
                        this.setActiveWindowModelById(State.data.state);
                    }
                }.bind(this));
        },

        addWindows: function (windowsModels) {
            if (windowsModels) {                
                this.windowsModels = this.windowsModels.concat(windowsModels);
            }
        },


        getDefaultWindow: function () {
            var default_id = this.defaultWindow;
            if (default_id) {
                return _.find(this.windowsModels,
                    function (model) {
                        return (model.typeName == default_id);
                    });
            }
            return _.find(this.windowsModels,
        		function (model) {
        		    return (model.parameters.IsDefault && model.parameters.IsDefault.value === true);
        		});
        },

        getDefaultWindowId: function () {
            if (this.defaultWindow) {
                return this.defaultWindow;
            } else {
                var defualtWindow = this.getDefaultWindow();
                if (defualtWindow !== undefined) {
                    return defualtWindow.parameters.Id.value;
                }
            }
            Error.onerror('Default window no found.');
        },

        setDefaultWindowById: function (id) {
            this.defaultWindow = id;
        },

        setActiveWindowModel: function (options) { //{windowModel, slient, withoutPushState, parameters}
            if (options.windowModel !== this.activeWindowModel) {
                var oldWindowModel = this.activeWindowModel;
                if (options.withoutPushState) {
                    var url = History.getState().url;
                    var parameters = url.queryStringToJSON();
                    var window_id = parameters[this.prefix];
                    if (window_id != undefined) {
                        var windowModel = this.getWindowModelById(window_id);
                        if (windowModel) {
                            options.windowModel = windowModel;
                        } else {
                            Error.onerror(String.format('Окна {0} нет в списке существующих окон', window_id));
                        }
                    }
                }
                this.activeWindowModel = options.windowModel;
                var savedModelparameters;
                if (options.parameters) { //сохраняем оригинальные параметры типа
                    savedModelparameters = $.extend(true, {}, options.windowModel.parameters);
                    $.extend(options.windowModel.parameters, options.parameters);
                }

                if (!options.withoutPushState && History.enabled) {
                    History.pushState({ state: options.windowModel.parameters.Id.value }, null,
                 String.format('?{0}={1}', this.prefix, options.windowModel.parameters.Id.value));
                }

                if (!options.slient) {                   
                    this.fireActiveWindowModelChanged(options.windowModel, oldWindowModel);
                }

                if (savedModelparameters) { //восстанавливаем оригинальные параметры типа
                    $.extend(options.windowModel.parameters, savedModelparameters);                    
                }
                savedModelparameters = undefined;
                this.activeWindowModel.url_parameters = parameters;
                return parameters;
            }
        },

        setActiveWindowModelById: function (windowModelId, parameters, withoutPushState) {
            var model = _.find(this.windowsModels,
               function (model) {
                   return model.parameters.Id.value == windowModelId;
                   
               });
            if (model) {
                this.setActiveWindowModel({ windowModel: model, slient: false, parameters: parameters, withoutPushState: withoutPushState });
            }
            else {
                Error.onerror(String.format('Window {0} no found.', windowModelId));
            }          
        },
        getWindowModelById: function (windowModelId, isCopy) {
            var windowModel =  _.find(this.windowsModels,
              function (model) {
                  return model.parameters.Id.value == windowModelId;
              });

            if (isCopy === true && windowModel !== undefined) {
                return $.extend(true, {}, windowModel);
            }
            return windowModel;
        },

        getActiveWindowModel: function () {
            return this.activeWindowModel;
        },

        openWindowInNewTab: function (windowModelId) {
            return window.open(String.format('?{0}={1}', this.prefix, windowModelId), '_blank');
        },

        subscribeActiveWindowModelChanged: function (handler, context) {
            this.eventTarget.addListener(ACTIVE_WINDOW_CHANGED, handler, context);
        },

        fireActiveWindowModelChanged: function (newWindowModel, oldWindowModel) {
            this.eventTarget.fire({ type: ACTIVE_WINDOW_CHANGED, target: this, newWindowModel: newWindowModel, oldWindowModel: oldWindowModel });
        }    
    });

    var instance = new WindowsManager();

    return instance;
});
