﻿// <copyright file="Action.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['when', 'base/ObservableObject', 'common/Utilites', 'base/Model', 'helpers/PermissionChecker', 'common/Error'],
    function (when, ObservableObject, Utilites, Model, PermissionChecker, Error) {
    var BEFORE_EXECUTE_ACTION = 'BeforeExecuteAction';
    var AFTER_EXECUTE_ACTION = 'AfterExecuteAction';

    var Action = Model.extend({

        init: function (options) {
            this._super();
            this.constants = $.extend(true, {}, options.constants);
            this._data = $.extend(true, {},options.parameters);          
            this.type = options.type;
            this.id = options.id;
            this.ClassName = this.type + '_' + this.id;
            this.constants.operation = this.constants.operation || 'move';
        },
        execute: function(context) {
            var ctx = this;
            var result = {};
            if (context != null)
                PermissionChecker.check(this.type, context, result);
            if (context == null || result.allow || Object.keys(result).length === 0) { //не на все действия можно выставить права
                return when.promise(function (resolve, reject, notify) {
                    ctx.fireBeforeExecuteAction(ctx.id);
                    ctx.executeInternal(context, resolve, reject, notify);
                }).then(function () {
                    ctx.fireAfterExecuteAction(ctx.id);
                }).catch(function (e) {
                    Error.onerror(e.message || e);
                });
            }
        },
        executeInternal: function (context, resolve, reject, notify) {

        },            

        subscribeBeforeExecuteAction: function (handler, context) {
            this.eventTarget.addListener(BEFORE_EXECUTE_ACTION, handler, context);
        },

        subscribeAfterExecuteAction: function (handler, context) {
            this.eventTarget.addListener(AFTER_EXECUTE_ACTION, handler, context);
        },

        fireBeforeExecuteAction: function (actionId) {
            this.eventTarget.fire({ type: BEFORE_EXECUTE_ACTION, target: this, actionId: actionId });
        },

        fireAfterExecuteAction: function (actionId) {
            this.eventTarget.fire({ type: AFTER_EXECUTE_ACTION, target: this, actionId: actionId });
        },
        destroy: function () {
        }
    });


    return Action;
});