﻿// <copyright file="CallMethodAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/Action', 'helpers/contextResolver', 'common/Enums', 'common/Error'],
    function (Action, contextResolver, Enums, Error) {

        var CallMethodAction = Action.extend({
            executeInternal: function (context, resolve, reject, notify) {
                var windowContext = contextResolver.getParentWindowControl(context);
                var methodContainer = contextResolver.resolve(this.constants.methodContainer, windowContext);
                var params = [];
                this.constants.parametersNames.forEach(function (paramName) {
                    params.push(this.get(paramName));
                }, this);
                                
                var methodName = Enums.methodType[this.constants.methodName];
                if (methodName === null) {
                    Error.onerror('Unknown method type ' + this.constants.methodName);
                    reject();
                    return;
                }

                if (methodContainer.controller[methodName]) {
                    var promise = methodContainer.controller.callMethod(methodName, params);
                    promise.then(function () {
                        resolve();
                    });
                } else {
                    console.warn('Method ' + this.constants.methodName + ' is not supported on ' + methodContainer.controller.ClassName);
                    reject();
                }
                params = null;
            }
        });


        return CallMethodAction;
    });