﻿// <copyright file="CallPOUAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'core/actions/Action', 'server/Server', 'common/Error', 'core/functionBlocks/TaskManager', 'when'], function (Enums, Action, Server, Error, TaskManager, when) {

    var CallPOUAction = Action.extend({
        executeInternal: function (context, resolve, reject, notify) {
            if (this.constants.fbType === Enums.fbType.ScreenTask) {
                this._callScreenFB(context, resolve, reject, notify);
            } else if (this.constants.fbType === Enums.fbType.MasterPLC) {
                this._callServerFB(context, resolve, reject, notify);
            } else {
                Error.onerror('Unknown FB type ' + this.constants.fbType);
            }
        },

        _callScreenFB: function (context, resolve, reject, notify) {
            var inputParams = {};
            var fbName = this.constants.path;
            this.constants.inputParameters.forEach(function (parameterName) {
                //FB.paramName без префикса у параметра
                var paramName = fbName + '.' + parameterName.substr(1);
                inputParams[paramName] = this.get(parameterName);
            }, this);

            var outputParams = _.map(this.constants.outputParameters, function (paramName) {
                return fbName + '.' + paramName.substr(1);
            }, this);

           /* TaskManager.getTask().call(fbName, inputParams, outputParams).then(function (outParams) {
                for (outputParamName in outParams) {
                    //преобразуем имя параметра из ФБ в имя параметра в акшене
                    var paramName = '_' + outputParamName.replace(fbName, '').substr(1);
                    this.set(paramName, outParams[outputParamName]);
                }
                                
                resolve();
                //т.к мы могла вписались до таймера, то следующим может выполнится execute,
                //ему в fbName следует отдать undefinied
                return when.resolve(undefined);
            }.bind(this));*/

            TaskManager.getTask().call(fbName, inputParams, outputParams, function (outParams) {
                for (outputParamName in outParams) {
                    //преобразуем имя параметра из ФБ в имя параметра в акшене
                    var paramName = '_' + outputParamName.replace(fbName, '').substr(1);
                    this.set(paramName, outParams[outputParamName]);
                }

                //т.к мы могла вписались до таймера, то следующим может выполнится execute,
                //ему в fbName следует отдать undefinied
                return undefined;
            }.bind(this));
        },

        _callServerFB: function (context, resolve, reject, notify) {
            var inputParams = [],
               outputParams = [];

            this.constants.inputParameters.forEach(function (parameterName) {
                var param = this.getProperty(parameterName);
                inputParams.push({
                    name: parameterName,
                    value: param.value,
                    typeHash: param.typeHash
                });
            }, this);

            this.constants.outputParameters.forEach(function (parameterName) {
                var param = this.getProperty(parameterName);
                outputParams.push({
                    name: parameterName,
                    type: param.typeName,
                    typeHash: param.typeHash
                });
            }, this);


            var query = {
                recs: [
                    {
                        taskId: this.constants.taskId,
                        callType: this.constants.callType,
                        itemId: this.constants.itemId,
                        typeHash: this.constants.typeHash,
                        path: this.constants.path,
                        params: inputParams,
                        outParams: outputParams
                    }
                ]
            };

            var that = this;
            Server.sendQuery("CallPOU", query).then(function (response) {
                if (response.data.recs !== undefined) {
                    var outputParamsResult = response.data.recs[0].outParams || [];
                    var i;
                    for (i = 0; i < outputParamsResult.length; i++) {
                        that.set(outputParams[i].name, outputParamsResult[i]);
                    }
                }

                resolve();
            }, function (response) {
                Error.onerror('Error calling FB ' + that.constants.itemId + '. Server response status: ' + response.status);
                reject('Error calling FB ');
            });
        }
    });


    return CallPOUAction;
});