﻿// <copyright file="FullScreenAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/Action', 'common/Enums', 'common/Error'],
    function (Action, Enums, Error) {

    var FullScreenAction = Action.extend({
        executeInternal: function (context, resolve, reject, notify) {
            if (screenfull.enabled) {
                if (this.constants.type === Enums.fullScreenDirection.enter) {
                    if (!screenfull.isFullscreen) {
                        screenfull.request(document.documentElement);                     
                    } else {                       
                        Error.warn('Already in fullscreen mode');                        
                    }
                } else {
                    if (screenfull.isFullscreen) {
                        screenfull.exit(document.documentElement);
                    } else {                        
                        Error.warn('Fullscreen mode is not active');                        
                    }
                }
            } else {
                Error.warn('Fullscreen is not enabled');               
            }

            resolve();
        }
    });


    return FullScreenAction;
});