﻿// <copyright file="OpenWindowActionBase.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/Action', 'common/Enums'
], function (Action, Enums) {

    var ControlFactory;
    var OpenDialogFrameControl;

        //broke cirle dependencies
        curl(['controls/ControlFactory'], function (cf) {
            ControlFactory = cf;
        });

        curl(['core/actions/OpenDialog/OpenDialogFrameControl'], function (cf) {
            OpenDialogFrameControl = cf;
        });

        var OpenWindowActionBase = Action.extend({            
            init: function (options) {
                this._super(options);              

                this.openedWindows = {};              
                this.replacedModelParameters = {};                             
                
                this.parametersChache = {
                    input: {},
                    output: {}
                };              
            },

            executeInternal: function (context, resolve, reject, notify) {
                            
            },

            getWindow: function () {
                return null;
            },

            _addInputParams: function () {
                _.forEach(this.constants.inputParameters, function (parameter) {
                    this.replacedModelParameters[parameter.name] = this.getProperty(parameter.name);
                }, this);
            },

            _bindProperties: function (windowObject) {
                this._cacheParams();
                this.getWindow().model.subscribePropertyChanged(this._onWindowPropertyChanged, this);
                this.subscribePropertyChanged(this._onModelPropertyChanged, this);
            },

            _onWindowPropertyChanged: function (event) {
                //если параметр выходной и по изменению
                if (this.parametersChache.output[event.property]) {
                    this.setProperty(event.property, this.getWindow().model.getProperty(event.property));
                }
            },

            _onModelPropertyChanged: function (event) {
                if (this.parametersChache.input[event.property]) {
                    this.getWindow().model.setProperty(event.property, this.getProperty(event.property));
                }              
            },

            _retrieveOutputPrams: function () {
                _.forEach(this.constants.outputParameters, function (parameter) {
                    this.setProperty(parameter.name, this.getWindow().model.getProperty(parameter.name));
                }, this);
            },

            addReplacedParameter: function (parameters) {
                $.extend(true, this.replacedModelParameters, parameters);
            },
                       
            _cacheParams: function () {
                _.forEach(this.constants.inputParameters, function (parameter) {
                    this.parametersChache.input[parameter.name] = parameter.update;
                }, this);
                _.forEach(this.constants.outputParameters, function (parameter) {
                    this.parametersChache.output[parameter.name] = parameter.update;
                }, this);
            }            

        });


        return OpenWindowActionBase;
    });
