﻿define(['common/Enums', 'core/AdapterFactory', 'core/convertations/ConvertationTypes'], function (enums, AdapterFactory, ConvertationTypes) {

	function ConvertationUsage(settings) {
		this.init(settings);
	}

	ConvertationUsage.prototype.init = function (options) {
		if (options instanceof Object) {
			$.extend(this, options || {});
		}

		if (options.defaultValue !== undefined) {
			var defCtor = AdapterFactory.getByType(this.defaultValue.type);
			this.defaultValue = new defCtor(this.defaultValue);
			defCtor = null;
		}

		this.type = ConvertationTypes.get(this.typeId);
	};

	ConvertationUsage.prototype.createPointAdapters = function () {

		this.sourceAdapters = [];
		this.targetAdapters = [];
		var sourceCtor,
			targetCtor;

		for (var i in this.points) {
			sourceCtor = AdapterFactory.getByType(this.points[i].source.type);
			targetCtor = AdapterFactory.getByType(this.points[i].target.type);
			this.sourceAdapters.push(new sourceCtor(this.points[i].source));
			this.targetAdapters.push(new targetCtor(this.points[i].target));
		}

		sourceCtor = null;
		targetCtor = null;
	};

	ConvertationUsage.prototype.updatePoints = function (ctx) {
		this.sourcePoints = [];
		this.targetPoints = [];
		for (var i = 0, l = this.sourceAdapters.length; i < l; i++) {
			var src = this.updatePoint(this.sourceAdapters[i].get(ctx), this.type.sourceType);
			var target = this.updatePoint(this.targetAdapters[i].get(ctx), this.type.targetType);
			this.sourcePoints.push(src);
			this.targetPoints.push(target);
		}
	};

	ConvertationUsage.prototype.updatePoint = function (point, type) {
        //INSAT: значения конвертируются на этапе кодогенерации. Конвертация в js больше не требуется
	    /*if (type === enums.ConvertationType.number) {
			point = Number(point);
		}

		if (type === enums.ConvertationType.boolean) {
			point = point.toLowerCase() === 'true' ? true : false;
		}*/

		return point;
	};

	ConvertationUsage.prototype.convert = function (variable, ctx) {
		if (variable === undefined) {
			return null;
		}

		this.updatePoints(ctx);
		var result = this.convertationRule(variable);
		if (result === undefined || result === null) {
			if (this.defaultValue !== undefined) {
				return this.defaultValue.get(ctx);
			}
		}
		var format = this.type.valueFormat;
		return String.format(format, result);
	};


	return ConvertationUsage;
});
