﻿// <copyright file="GlobalEvents.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['curl/_privileged', 'base/EventTarget', 'common/Enums'],
    function (priv, EventTarget, Enums) {

    var GlobalEvents = EventTarget.extend({
        init: function () {
            this._listeners = {};          
            this._addFetchEvent();
        },

        _addFetchEvent: function () {
            this._listeners[Enums.GlobalEventsTypes.resourceFetched] = [];
            priv['core']['onResourceFetched'] = function (id) {
                //console.log(id);
                this.fire({
                        type: Enums.GlobalEventsTypes.resourceFetched,
                        id: id
                    });
            }.bind(this);
        },

        onClientErrorOccured: function (error) {
            this.fire({ type: Enums.GlobalEventsTypes.clientErrorOccured, error: error });
        },

        subscribeClientErrorOccured: function(handler, ctx) {
            this.addListener(Enums.GlobalEventsTypes.clientErrorOccured, handler, ctx);
        }
    });

    var instance = new GlobalEvents();

    return instance;
});