﻿// <copyright file="PredefinedCondition.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'core/trigger/conditions/Condition', 'common/Utilites'], function (Enums, Condition, Utilites) {
    var PredefinedCondition = Condition.extend({        
        init: function (options, conditionsDictionary, conditionFactory) {
            conditionsDictionary[options.id] = this;
            this._super(options, conditionsDictionary, conditionFactory);
            // у predefined состояние true/false
            // this.data.compareWith = options.compareWith.toLowerCase() == 'true';
            //начальное значение false - т.к мышь не навередна/нажата и т.д.
            this.compareWithCurrent = {
                typeName: this._data.compareWith.typeName,
                value: false
            };
        },

        changeConditionState: function (conditionState) {
            //this.data.compareWith может динамизироватся,
            //поэтому сравниваем установленое состояние с ожидаемым
            //т.к тип всегда bool - не заморачиваемся с сравнениями
            switch (conditionState) {
                case Enums.ConditionState.set:
                    if (this.compareWithCurrent.value !== true) {
                        this.compareWithCurrent.value = true;
                        this.onConditionStateChanged();                       
                    }
                    break;
                case Enums.ConditionState.unset:
                    if (this.compareWithCurrent.value !== false) {
                        this.compareWithCurrent.value = false;
                        this.onConditionStateChanged();                       
                    }
                    break;
            }
        },

        checkCurrentCondition: function () {
            return Utilites.equal(this.compareWithCurrent, this._data.compareWith);
        }      
    });

    return PredefinedCondition;
})