﻿define(['core/L10n'], function (L10n) {

    var PermissionChecker = {};
    PermissionChecker.check = function (type, context, result) {
        var control = context.mvc;
        while (control && control.model.permissions) {
            var permission = control.model.permissions[type];
            if (permission && permission[this.currentOperator]) {
                result.allow = permission[this.currentOperator].Enable || result.allow;
                result.deny = permission[this.currentOperator].Disable || result.deny;
                result.confirmation = permission[this.currentOperator].Confirmation || result.confirmation;
                result.writelog = permission[this.currentOperator].WriteLog || result.writelog;
            }
            control = control._parent;
        }
        if (result.deny) {
            result.allow = false;
        }
        return result;
    },
    PermissionChecker.setOperator = function (operator) {
        this.currentOperator = operator;
    //    GlobalSettings.CurrentOperator = operator;
    },
    PermissionChecker.getOperator = function () {
        return this.currentOperator;
    },
    PermissionChecker.needCheck = function(){
        if (this.currentOperator) {
            return true;
        }
        else {
            return false;
        }
    }
    return PermissionChecker;
});