﻿// <copyright file="Logger.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['server/Server', 'common/Enums',],
    function(server, Enums) {

        function ServerLogger() {
            this.filterLevel = Enums.logLevel.info;
        }

        ServerLogger.prototype.logMessage = function (text, level, data) {
            if (data && data.queryType === Enums.queryType.logMessage){               
                return; //communication error  - can't send 
            }

            if (level >= this.filterLevel) {
                var msg = text;
                if (data) {
                    msg = JSON.stringify({
                        message: text,
                        data: data
                    });
                }
                var query = {
                    level: level,
                    message: msg
                };

                return server.sendQuery("LogMessage", query).then(function (result) {
                    return result;
                });
            }
        }

        ServerLogger.prototype.sendStatistics = function(text, statistics) {
            this.logMessage(text, Enums.logLevel.info, statistics);
        }

        return new ServerLogger();
});