// <copyright file="ServerStateManager.js" company="">
// , 2014
// </copyright>
// _completedRequest

define(['base/ObservableObject', 'core/global/GlobalEvents', 'common/Enums'],
    function (ObservableObject, GlobalEvents, Enums) {

	var ServerStateManager = ObservableObject.extend({
       
	    init: function () {
	        this.state = {
	            timeToSetValues: false,
	            sendGlobalCounter: 0,
	            connectionError: false,
	            SubscriptionId: -1,
	            Connected: false,
	            IsValuesAdded: false,
	            requestedPublishingInterval: 1000,
	            requestedLifetimeInterval: 300000,
	            maxNotificationsPerPublish: 0,
	            maxSize: 1000,
	            ackSequenceNumber: 0,
                serverTime: 0
	        };

	        this._super();
	    },

		get: function(name) {
			return this.state[name]
		},
		set: function (name, value, slient) {
		    var oldValue = this.state[name];
		    this.state[name] = value;

		    if (name == 'Connected') {
		        this.setConnected(value)
		    }

		    if (!slient) {
		        this.firePropertyChanged(name, oldValue, value);
		    }
		},

		setConnected: function (value) {
		    GlobalEvents.fire({ type: value ? Enums.GlobalEventsTypes.online : Enums.GlobalEventsTypes.offline });
		}
	});

	return ServerStateManager;
});