﻿// <copyright file="DataAdapterErrorProcessor.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'core/L10n'], function (enums, L10n) {

    var stateVars = enums.serverState;
    var id = 0;
    var opcErrorsPrefix = 'opcErrors.';
    var opcUndefError = 'undefined';
    var opcBadSessionInvalid = 0x80250000;
    var opcBadTooManySessions = 0x80560000;
    function DataAdapterErrorProcessor(serverStateManager) {
        this.previousCommand = null;
        this.retryTimer = null;
        this.manager = serverStateManager;
        this.errorHandlers = new errorHandlersPrototype(this.manager);
        this.manager.subscribePropertyChanged(this.errorHandlers.CreateDataSubscription._onConnectionStateChanged, this);
    }

    DataAdapterErrorProcessor.prototype.resetErrorStatus = function (command) {
        this.errorHandlers.totalErrors = 0;
        if (!this.manager.get(stateVars.Connected) && this.manager.get(stateVars.connectionError)){
            location.reload(); //связи не было, но она вернулась
        }
        if (this.errorHandlers[command]) {
            this.errorHandlers[command].retryCount = 0;
        }
    };

    // responceData: plain string with OPC error code and JSON data bound to error. Can be empty.
    DataAdapterErrorProcessor.prototype.processServerError = function (responceData, command) {
        var serverData = null;

        try {
            serverData = typeof responceData == 'string' ? $.parseJSON(responceData) : responceData;
        } catch (err) {
            serverData = {
                code: 0,
                message: "Invalid JSON responce from server.",
                queryType: command,
            }
        }

        var code = serverData.code;
        this.errorHandlers.totalErrors++;
        var errorHandler = null;

        if (this.errorHandlers.totalErrors > 3) {
            errorHandler = this.errorHandlers.CreateDataSubscription;
        } else {
            errorHandler = this.errorHandlers[command] || this.errorHandlers.Default;
        }
        this.previousCommand = command;
        var handlers = errorHandler.handlers,
            handler = handlers[code];
        errorHandler.retryCount++;


        var handlers = errorHandler.handlers, handler = handlers[code];


        if (handler == undefined) {
            handler = handlers.general;
        }

        var result = handler.call(errorHandler, serverData, this.manager);
        serverData = null;
        errorHandler = null;
        this.previousCommand = command;
        // to avoid undefined rejections
        return result || L10n.get(opcErrorsPrefix + responceData.code);
    };

    // An object that consists from error handlers. Key is error code
    // Value - function to process error with code, specified as key.
    var errorHandlersPrototype = function (manager) {
        this.totalErrors = 0;
        this.Default = new function () {
            this.retryCount = 0;
            this.maxErrors = 3;
            this.handlers = {
                general: function (data, manager) {
                    if (this.retryCount >= 3 || manager.get(stateVars.Connected) == false) {
                        manager.set(stateVars.Connected, false);
                        //    dataAdapter.logout();
                    }
                    if (data !== undefined) {
                        return String.format('Query: {0}, {1} code: {2}, ', data.queryType, data.message, data.code);
                    }
                }
            }
        }();

        this.CreateDataSubscription = new function (mng) {
            this.retryCount = 0;
            this.maxErrors = 3;
            this.retryInterval = 1000;
            this.maxRetryInterval = 60000;
            this.retryTimer = null;
            this.manager = mng;
            this._onConnectionStateChanged = function (event) {
                //unsubscribe on response
                if (event.property === stateVars.Connected) {
                    if (this.manager.get(stateVars.Connected) === true) {
                    //    this.manager.unsubscribePropertyChanged(this._onConnectionStateChanged);
                        clearInterval(this.retryTimer);
                        this.retryInterval = 1000;
                        this.retryCount = 0;
                        this.manager.set(stateVars.wasRecconected, true);
                        this.manager.set(stateVars.connectionError, false);
                        $(".outer").remove();
                    } else {
                        if ($(".outer").length == 0) {
                            var message = document.createElement('div');
                            message.className = "outer";
                            message.style.top = "0px";
                            message.style.left = "0px";
                            message.style.width = "100%";
                            message.style.height = "100%";
                            message.style.position = "absolute"
                            message.innerHTML = '<div class="login">\
                                        <span>' + 'Нет соединения с сервером' + '</span>\
                                    </div>';
                            document.body.appendChild(message);
                        }
                    }
                }
            }.bind(this);

            this.handlers = {              

                general: function (data, manager) {
                    if (this.retryCount === 1) {
                        var onConnectionTimer = function () {
                            this.updateRetryInterval();
                            if (this.retryCount >= this.maxErrors) {
                                manager.set(stateVars.connectionError, true);
                                if (data.code == opcBadTooManySessions) {
                                    document.querySelector("div[data-control-id=schema]").innerHTML = '<div class="outer" style="height: 100%; width: 100%">\
                                    <div class="login">\
                                        <span>' + L10n.get(opcErrorsPrefix + data.code) + '</span>\
                                    </div>\
                            </div>';
                                }
                            }
                            this.retryCount++;
                            manager.set(stateVars.Connected, false);
                            this.retryTimer = setTimeout(onConnectionTimer, this.retryInterval);
                        }.bind(this);

                        onConnectionTimer();
                    }

                    if (data !== undefined) {
                        return String.format('CreateDataSubscription error: {0} code: {1}, ', data.message, data.code);
                    }
                }
            };
         this.updateRetryInterval = function(){
             this.retryInterval = Math.E * this.retryInterval;
             this.retryInterval = this.retryInterval > this.maxRetryInterval
                 ? this.maxRetryInterval : this.retryInterval;
         }
        }(manager);

        this.Login = new function () {
            this.retryCount = 0;
            this.maxErrors = 3;
            this.handlers = {
                general: function (data) {                    
                    return L10n.get(opcErrorsPrefix + data.code) || ''
                }
            }
        }();
    };

    return DataAdapterErrorProcessor;
});