﻿// <copyright file="DataAdapterOld.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['server/Server', 'server/adapters/DataAdapterOldErrorProcessor', 'when', 'common/Utilites', 'server/ServerStateManagerOld', 'common/Enums', 'server/VariablesManager'],
    function (server, errorProcessor, when, utils, serverStateManager, enums, VariablesManager) {

    var lastQueries = {},
    // we want to send only updated values, so just sending Values array is not enough
    // here will be filtered list of values
    // array of groups with nested arrays of variables
    valuesToSend = [],
    varsForSubscribe = undefined,
    Values = { vals: [] };
    sGet = serverStateManager.get.bind(serverStateManager),
    sSet = serverStateManager.set.bind(serverStateManager),
    stateVars = enums.serverState;


    function DataAdapterOld() {
        serverStateManager.subscribePropertyChanged(this.stateChanged, this);
    }

    DataAdapterOld.prototype.init = function ()
    {
        var def = when.defer();

        create().then(function () {
            initValues().then(function () {
                def.resolve();
            });
        });

        return def.promise;
    }

    DataAdapterOld.prototype.stateChanged = function(event) {
        switch(event.property) {
            case stateVars.Connected:
                if(!sGet(stateVars.Connected)) {
                    this.create();
                }
                break;
        }
    }

    DataAdapterOld.prototype.get = function () {
        return getValues();
    }

    DataAdapterOld.prototype.set = function (value) {
        addValueToSend(value);
        return setValues();
    }

    function sendQuery(command, parameters) {
        var def = when.defer();
        server.sendQuery(command, parameters).then(function (result) {
            processResponse(result);
            def.resolve(result);
        }, function (result) {
            processResponse(result);
            def.reject({message: 'server error'});
        });

        return def.promise;
    }

    function processResponse(result) {
        if (result.status == 200 && !result.data.redirect) {
            if (errorProcessor.wasError(result.command)) {
                errorProcessor.resetErrorStatus(result.command);
            }
        }
        else {
            if (result.status == 501) {
                // process only internal server errors here
                errorProcessor.processServerError(result.data, result.command);
            }         
        }
    }

    function initValues() {
        var def = when.defer();
        return addValToSubscription('[{ "group": 0, "vars": [{ "itemid": 31032, "path": "", "typehash": 1 }] }]')
        .then(function () {
            setTasknumbers([0]);
            Values.vals.push({ "tasknumber": 0, "itemid": 31032, "path": "", "typehash": 1, "value": "", "type": "INT" });
            def.resolve();
        });
        return def.promise;
    }

    function create() {
        return sendQuery('CreateSubscribe').then(function (result) {
            sSet(stateVars.Connected, true);
            sSet(stateVars.SubsriptionId, result.data.subsription);
        });
    }

    function destroy() {
        return sendQuery('DeleteSubscribe', { subsriptionId: sGet(stateVars.SubsriptionId) }).then(function () {
            sSet(stateVars.SubsriptionId, -1);
        });
    }

    function addValToSubscription(data) {
        varsForSubscribe = '{ "subsription" : ' + sGet(stateVars.SubsriptionId) + ', "data":' + data + '}';
        return sendQuery('AddValToSubscription', varsForSubscribe).then(function () {
            sSet(stateVars.IsValuesAdded, true);
        });
    }

    function setTasknumbers(tasknumbers) { //TODO таскнамберы и так стоят, а тут походу просто добавляем в массив
        for (var i = 0, l = tasknumbers.length; i < l; ++i) {
            valuesToSend.push({ tasknumber: tasknumbers[i], vars: [] });
        }
    }

    function getValues() {
        if (sGet(stateVars.Connected) && sGet(stateVars.IsValuesAdded)) {
            return sendQuery('GetValues', { subsription: sGet(stateVars.SubsriptionId), data: Values.vals })
            .then(function (result) {              
                for (var i = 0; i < result.data.length; i++) {
                    VariablesManager.setVariable(result.data[i]);
                }

                sSet(stateVars.timeToSetValues, true);
            });
        }
    }

    function addValueToSend(variable) {
        for (var i = 0, l = valuesToSend.length; i < l; ++i) {
            // if tasknumbers are equal, check if there is already exists same variable
            // if exists, simply update variable value
            if (variable.tasknumber == valuesToSend[i].tasknumber) {
                var k = valuesToSend[i].vars.length - 1;
                for (var j = 0; j < k; ++j) {
                    if (valuesToSend[i].vars[j].itemid == variable.itemid
                        && valuesToSend[i].vars[j].path == variable.path && valuesToSend[i].vars[j].value !== variable.value) {
                        valuesToSend[i].vars[j].value = variable.value;
                        valuesToSend[i].vars[j].sendTimeSpan = sendGlobalCounter++;
                        return;
                    }
                }

                variable.sendTimeSpan = sendGlobalCounter++;
                valuesToSend[i].vars.push(variable);
                return;
            }
        }

        console.log('Group and tasknumber for variable ' + variable.itemid + ' is absent!');
    }

    function setValues() {
        if (sGet(stateVars.Connected) && sGet(stateVars.IsValuesAdded) && valuesToSend[0].vars.length > 0 && sGet(stateVars.timeToSetValues)) {
                var request = { subscription: SubsriptionId, groups: valuesToSend, sendTimeSpan: sendGlobalCounter };
                return sendQuery('SetValues', request).then(function (result) {
                    var deleted = [];
                    var sendTimeSpan = result.parameters.sendTimeSpan;
                    result.parameters = result.parameters.groups;
                    for (var i = 0, l = valuesToSend.length; i < l; ++i) {
                        for (var j = 0, k = valuesToSend[i].vars.length; j < k; ++j) {
                            //VictorM Необходимо сравнивать sendTimeSpan, чтобы убедится,
                            //что во время выполнения запроса не было поставлено новых команд записи по этому параметру
                            if (valuesToSend[i].vars[j].itemid == result.parameters[i].vars[j].itemid && valuesToSend[i].vars[j].sendTimeSpan < sendTimeSpan) {
                                deleted.push(result.parameters[i].vars[j]);
                            }
                        }

                        utils.removeArrayItems(valuesToSend[i].vars, deleted);
                    }
                });
        }
    }

    return DataAdapterOld;
});