﻿// <copyright file="DataAdapterOldErrorProcessor.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['server/ServerStateManagerOld', 'common/Enums'], function (manager, enums) {

     var stateVars = enums.serverState;

    function DataAdapterOldErrorProcessor() {
        this.previousCommand = null;
        this.retryTimer = null;
    }

    DataAdapterOldErrorProcessor.prototype.resetErrorStatus = function (command) {
        if (this.errorHandlers[command]) {
            this.errorHandlers[command].retryCount = 0;
        }
    };

    DataAdapterOldErrorProcessor.prototype.wasError = function (command) {
        if (this.errorHandlers[command]) {
            return this.errorHandlers[command].retryCount > 0;
        }

        return false;
    }
    // responceData: plain string with OPC error code and JSON data bound to error. Can be empty.
    DataAdapterOldErrorProcessor.prototype.processServerError = function (responceData, command) {
        var serverData = null;      

        try {
            serverData =  typeof responceData == 'string' ?  $.parseJSON(responceData) : responceData;
        } catch (err) {
            console.log('Invalid JSON responce from server');
            return;
        }

        var errorHandler = this.errorHandlers[command];
        var code = serverData.code;
        if (code === '') {
            console.log('Error code is empty');
        }
        if (this.previousCommand === null || this.previousCommand === command) {
            errorHandler.retryCount++;
        }

        this.previousCommand = command;
        var handlers = errorHandler.handlers, handler = null;
        for (var i in handlers) {
            if (code == i) {
                handler = handlers[i];
                break;
            }
        }

        if (handler === null) {
            console.log('no handler for error with code ' + code);
            return;
        }

        handler.call(errorHandler, serverData.data);
        serverData = null;
        errorHandler = null;
    };

    // An object that consists from error handlers. Key is error code
    // Value - function to process error with code, specified as key.
    DataAdapterOldErrorProcessor.prototype.errorHandlers = {
        GetValues: new function () {
            this.retryCount = 0;
            this.maxErrors = 3;
            this.handlers = {
                1: function (data) {
                    if (this.retryCount === 3) {
                        manager.set(stateVars.Connected, false);
                    }                    
                }
            }
        }(),
        SetValues: new function () {
            this.retryCount = 0;
            this.maxErrors = 3;
            this.handlers = {
                1: function (data) {
                    
                }
            }
        }(),
        AddValToSubscription: new function () {
            this.retryCount = 0;
            this.maxErrors = 3;
            this.handlers = {
                1: function (data) {
                }
            }
        }(),
        CreateSubscribe: new function () {
            this.retryCount = 0;
            this.maxErrors = 3;
            var retryInterval = 1000;
            this.handlers = {
                1: function (data) {
                    if (this.retryCount === 1) {
                         retryTimer = setInterval(function () {
                            if (this.retryCount === that.maxErrors) {
                                // TODO show connection error icon.
                            }
                            manager.set(stateVars.Connected, false);
                        }, retryInterval);

                        manager.subcribePropertyChanged(function(event) {
                            if(event.property === stateVars.Connected && manager.get(stateVars.Connected) === true) {
                                clearInterval(retryTimer);
                            }
                        }, this);                       
                       
                    }
                }
            }
        }()
    };

    var instance = new DataAdapterOldErrorProcessor();

    return instance;
});