﻿// <copyright file="DataAdapter.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['when', 'common/Enums', 'server/adapters/DataAdapterBase', 'controls/ParametersFactory', 'helpers/XhrWrapper'],
    function (when, Enums, DataAdapterBase, ParametersFactory, XhrWrapper) {

     var ODATAAdapter = DataAdapterBase.extend({
         init: function (serverStateManager, model) {
             this._super(serverStateManager, model);          
         },

         _initOptions: function () {
             this.options = {
                 url: this.model.get(Enums.ParameterRoles.URL),
                 filter: this.model.get(Enums.ParameterRoles.FILTER),
                 typeName: this.model.getProperty(Enums.ParameterRoles.VALUE).typeName
             };

             this.options.expand = this._buildExpandForType(this.options.typeName, '');
             this.options.expand = this.options.expand ? '?$expand=' + this.options.expand : '';
         },
         
         _buildExpandForType: function (typeName, parentPath) {
             var type = ParametersFactory.getType(typeName);
             if (type === undefined) {
                 console.error(String.format('Cannot build expand for type {0}', typeName));
                 return '';
             }

             switch (type.type) {
                 case Enums.type.object:
                     return this._buildExpandForObject(typeName, parentPath);
                 case Enums.type.array:
                     return this._buildExpandForArrayParam(typeName, parentPath);
                 default:
                     return '';
             }
         },       

         _buildExpandForObject: function (typeName, parentPath) {
             var type = ParametersFactory.getType(typeName);
             //дочерние объекты будут иметь путь CurrObj/SubObj или Parent/CurrObj/SubObj   
             var prefix = parentPath === '' ? '' : parentPath + '/';
             var result = parentPath;
             _.forOwn(type.description, function (descType, descName) {              
                 var subExpand = this._buildExpandForType(descType, prefix + descName);
                 if (subExpand !== '') {
                     result = result !== '' ? result + ',' + subExpand : subExpand;
                 }
             }, this);

             return result;
         },
        
         _buildExpandForArrayParam: function (typeName, parentPath) {
             var type = ParametersFactory.getType(typeName);             
             var arrItemType = type.description.arrayItemType;          
             
             return this._buildExpandForType(arrItemType, parentPath);
         },
        
         getAll: function () {            
             return this.sendQuery(Enums.queryType.get, {}, this.options.expand);
         },

         writeData: function (items) {
             return this.sendQuery(Enums.queryType.put, items, '');
         },

         sendQuery: function (command, parameters, expand) {
             var ctx = this;
             var def = when.defer();

             return XhrWrapper.loadUrl(
             this.options.url + this.options.filter + expand,
             command,
             typeof parameters == 'string' ? parameters : JSON.stringify(parameters)).
             then(function (response) {
                 delete response.data['odata.metadata'];
                 return { status: response.status, data: response.data, command: command, parameters: parameters };
             });           
         }
     });

     return ODATAAdapter;
 });