﻿// <copyright file="DataAdapter.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['when', 'common/Utilites',
 'common/Enums', 'server/adapters/DataAdapterBase', 'js!libs/xml2json!order', 'js!libs/jquery_soap!order'],
 function (when, utils, enums, DataAdapterBase) {

     var SOAPAdapter = Class.extend({
         init: function (serverStateManager, model) {
             this._super(serverStateManager, model);
         },

         _initOptions: function () {
             this.options = {
                 url: this.model.get(Enums.ParameterRoles.URL),
                 soapAction: this.model.get(Enums.ParameterRoles.FILTER),
                 method: this.model.get(Enums.ParameterRoles.FILTER)
             }
         },

         getAll: function () {
             var ctx = this;
             return this.sendQuery(this.options.method, this.options.soapAction, {});
         },

         writeData: function (items) {                   
             return this.sendQuery(this.options.method, this.options.soapAction, items);
         },

         sendQuery: function (method, soapAction, data) {
             var ctx = this;
             var def = when.defer();
             var resultTagName = method + 'Result';

             $.soap({
                 url: this.options.url,
                 method: method,
                 SOAPAction: soapAction,
                 data: data,
                 appendMethodToURL: false,
                 namespaceURL: 'http://tempuri.org/',
                 success: function (soapResponse) {
                     var resultElement = $(soapResponse.content).find(resultTagName)[0];
                     var res = $.xml2json(resultElement, { normilize: false, removePrefix: true });
                     var result = res[resultTagName];
                     def.resolve(result);

                 },
                 error: function (soapResponse) {
                     def.resolve(soapResponse);
                 }
             });

             return def.promise;
         }

     });

     return SOAPAdapter;
 });